/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.utils;

import com.spectralogic.ds3client.utils.Guard;
import java.io.InputStream;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PropertyUtils {
    private static final Logger LOG = LoggerFactory.getLogger(PropertyUtils.class);
    private static final String SDK_VERSION_PROPERTY_NAME = "version";
    private static final String GIT_COMMIT_HASH_PROPERTY_NAME = "git.commitHash";
    private static final String PROPERTIES_FILE_NAME = "ds3_sdk.properties";
    private static final AtomicReference<String> versionProperty = new AtomicReference<String>("");
    private static final AtomicReference<String> gitCommitHashProperty = new AtomicReference<String>("");

    private PropertyUtils() {
    }

    public static String getSdkVersion() {
        return PropertyUtils.getPropertyFromPropertiesFile(SDK_VERSION_PROPERTY_NAME, versionProperty);
    }

    private static String getPropertyFromPropertiesFile(String propertyName, AtomicReference<String> propertyValue) {
        if (!Guard.isStringNullOrEmpty((String)propertyValue.get())) {
            return propertyValue.get();
        }
        String propertyFromPropertiesFile = PropertyUtils.getPropertyFromPropertiesFile(propertyName);
        if (!Guard.isStringNullOrEmpty((String)propertyFromPropertiesFile)) {
            propertyValue.set(propertyFromPropertiesFile);
        }
        return propertyValue.get();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getPropertyFromPropertiesFile(String propertyName) {
        Properties properties = new Properties();
        try (InputStream propertiesStream = PropertyUtils.class.getClassLoader().getResourceAsStream(PROPERTIES_FILE_NAME);){
            if (propertiesStream == null) return "";
            properties.load(propertiesStream);
            Object propertyObject = properties.get(propertyName);
            if (propertyObject == null) return "";
            String string = properties.get(propertyName).toString();
            return string;
        }
        catch (Throwable t) {
            LOG.warn("Could not read properties file.", t);
        }
        return "";
    }

    public static String getGitCommitHash() {
        return PropertyUtils.getPropertyFromPropertiesFile(GIT_COMMIT_HASH_PROPERTY_NAME, gitCommitHashProperty);
    }
}

