/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.client;

import com.joyent.manta.client.MantaObject;
import java.util.Comparator;
import org.apache.commons.lang3.StringUtils;

public final class MantaObjectDepthComparator
implements Comparator<MantaObject> {
    public static final MantaObjectDepthComparator INSTANCE = new MantaObjectDepthComparator();

    private MantaObjectDepthComparator() {
    }

    @Override
    public int compare(MantaObject o1, MantaObject o2) {
        int depthComparison = MantaObjectDepthComparator.comparePathDepth(o1, o2);
        if (depthComparison == 0) {
            if (!o1.isDirectory() == !o2.isDirectory()) {
                return 0;
            }
            if (!o1.isDirectory()) {
                return -1;
            }
            return 1;
        }
        return depthComparison;
    }

    private static int comparePathDepth(MantaObject o1, MantaObject o2) {
        int o1Depth = StringUtils.countMatches((CharSequence)o1.getPath(), (CharSequence)"/");
        int o2Depth = StringUtils.countMatches((CharSequence)o2.getPath(), (CharSequence)"/");
        return Integer.compare(o2Depth, o1Depth);
    }
}

