/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.http;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.http.conn.DnsResolver;

public class ShufflingDnsResolver
implements DnsResolver {
    public InetAddress[] resolve(String host) throws UnknownHostException {
        InetAddress[] addresses = InetAddress.getAllByName(host);
        ShufflingDnsResolver.shuffle(addresses);
        return addresses;
    }

    private static void shuffle(InetAddress[] addresses) {
        if (addresses.length < 2) {
            return;
        }
        ThreadLocalRandom random = ThreadLocalRandom.current();
        for (int i = addresses.length - 1; i > 0; --i) {
            int index = ((Random)random).nextInt(i + 1);
            InetAddress a = addresses[index];
            addresses[index] = addresses[i];
            addresses[i] = a;
        }
    }
}

