/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.DescriptiveUrl;
import ch.cyberduck.core.DescriptiveUrlBag;
import ch.cyberduck.core.HostPasswordStore;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.PasswordStoreFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.Scheme;
import ch.cyberduck.core.URIEncoder;
import ch.cyberduck.core.UrlProvider;
import ch.cyberduck.core.UserDateFormatterFactory;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.s3.RequestEntityRestStorageService;
import ch.cyberduck.core.s3.S3PathContainerService;
import ch.cyberduck.core.s3.S3PresignedUrlProvider;
import ch.cyberduck.core.s3.S3Session;
import ch.cyberduck.core.s3.S3TorrentUrlProvider;
import ch.cyberduck.core.shared.DefaultUrlProvider;
import java.net.URI;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jets3t.service.utils.ServiceUtils;

public class S3UrlProvider
implements UrlProvider {
    private static final Logger log = Logger.getLogger(S3UrlProvider.class);
    private final PathContainerService containerService = new S3PathContainerService();
    private final HostPasswordStore store;
    private final S3Session session;

    public S3UrlProvider(S3Session session) {
        this(session, PasswordStoreFactory.get());
    }

    public S3UrlProvider(S3Session session, HostPasswordStore store) {
        this.session = session;
        this.store = store;
    }

    public DescriptiveUrlBag toUrl(Path file) {
        DescriptiveUrlBag list = new DescriptiveUrlBag();
        if (file.isFile()) {
            list.add(this.toUrl(file, this.session.getHost().getProtocol().getScheme(), this.session.getHost().getPort()));
            list.add(this.toUrl(file, Scheme.http, 80));
            if (!this.session.getHost().getCredentials().isAnonymousLogin()) {
                list.add(this.sign(file, (int)TimeUnit.HOURS.toSeconds(1L)));
                list.add(this.sign(file, (int)TimeUnit.SECONDS.toSeconds(PreferencesFactory.get().getInteger("s3.url.expire.seconds"))));
                list.add(this.sign(file, (int)TimeUnit.DAYS.toSeconds(7L)));
                switch (this.session.getSignatureVersion()) {
                    case AWS2: {
                        list.add(this.sign(file, (int)TimeUnit.DAYS.toSeconds(30L)));
                        list.add(this.sign(file, (int)TimeUnit.DAYS.toSeconds(365L)));
                        break;
                    }
                }
            }
            list.add(new DescriptiveUrl(URI.create(new S3TorrentUrlProvider(this.session.getHost()).create(this.containerService.getContainer(file).getName(), this.containerService.getKey(file))), DescriptiveUrl.Type.torrent, MessageFormat.format(LocaleFactory.localizedString((String)"{0} URL"), LocaleFactory.localizedString((String)"Torrent"))));
        }
        list.addAll((Collection)new DefaultUrlProvider(this.session.getHost()).toUrl(file));
        if (!file.isRoot()) {
            list.add(new DescriptiveUrl(URI.create(String.format("s3://%s%s", this.containerService.getContainer(file).getName(), this.containerService.isContainer(file) ? "/" : String.format("/%s", URIEncoder.encode((String)this.containerService.getKey(file))))), DescriptiveUrl.Type.provider, MessageFormat.format(LocaleFactory.localizedString((String)"{0} URL"), "S3")));
        }
        return list;
    }

    protected DescriptiveUrl toUrl(Path file, Scheme scheme, int port) {
        StringBuilder url = new StringBuilder(scheme.name());
        url.append("://");
        if (file.isRoot()) {
            url.append(this.session.getHost().getHostname());
            if (port != scheme.getPort()) {
                url.append(":").append(port);
            }
        } else {
            String hostname = this.getHostnameForContainer(this.containerService.getContainer(file));
            if (hostname.startsWith(this.containerService.getContainer(file).getName())) {
                url.append(hostname);
                if (port != scheme.getPort()) {
                    url.append(":").append(port);
                }
                if (!this.containerService.isContainer(file)) {
                    url.append('/');
                    url.append(URIEncoder.encode((String)this.containerService.getKey(file)));
                }
            } else {
                url.append(this.session.getHost().getHostname());
                if (port != scheme.getPort()) {
                    url.append(":").append(port);
                }
                url.append(URIEncoder.encode((String)file.getAbsolute()));
            }
        }
        return new DescriptiveUrl(URI.create(url.toString()), DescriptiveUrl.Type.http, MessageFormat.format(LocaleFactory.localizedString((String)"{0} URL"), scheme.name().toUpperCase(Locale.ROOT)));
    }

    protected DescriptiveUrl sign(Path file, int seconds) {
        Calendar expiry = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        expiry.add(13, seconds);
        String secret = this.store.findLoginPassword(this.session.getHost());
        if (StringUtils.isBlank((CharSequence)secret)) {
            log.warn((Object)"No secret found in password store required to sign temporary URL");
            return DescriptiveUrl.EMPTY;
        }
        String region = this.session.getHost().getRegion();
        if (this.session.isConnected() && ((RequestEntityRestStorageService)((Object)this.session.getClient())).getRegionEndpointCache().containsRegionForBucketName(this.containerService.getContainer(file).getName())) {
            region = ((RequestEntityRestStorageService)((Object)this.session.getClient())).getRegionEndpointCache().getRegionForBucketName(this.containerService.getContainer(file).getName());
        }
        return new DescriptiveUrl(URI.create(new S3PresignedUrlProvider().create(this.session.getSignatureVersion(), this.session.getHost().getHostname(), this.session.getHost().getCredentials().getUsername(), secret, this.containerService.getContainer(file).getName(), region, this.containerService.getKey(file), "GET", expiry.getTimeInMillis())), DescriptiveUrl.Type.signed, MessageFormat.format(LocaleFactory.localizedString((String)"{0} URL"), LocaleFactory.localizedString((String)"Pre-Signed", (String)"S3")) + " (" + MessageFormat.format(LocaleFactory.localizedString((String)"Expires {0}", (String)"S3") + ")", UserDateFormatterFactory.get().getMediumFormat(expiry.getTimeInMillis())));
    }

    private String getHostnameForContainer(Path bucket) {
        if (!ServiceUtils.isBucketNameValidDNSName((String)this.containerService.getContainer(bucket).getName())) {
            return this.session.getHost().getHostname();
        }
        if (this.session.getHost().getHostname().equals(this.session.getHost().getProtocol().getDefaultHostname())) {
            return String.format("%s.%s", bucket.getName(), this.session.getHost().getHostname());
        }
        return this.session.getHost().getHostname();
    }
}

