/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.BookmarkNameProvider;
import ch.cyberduck.core.Collection;
import ch.cyberduck.core.EditableCollection;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostFilter;
import ch.cyberduck.core.text.DefaultLexicographicOrderComparator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public abstract class AbstractHostCollection
extends Collection<Host>
implements EditableCollection {
    private static final Logger log = Logger.getLogger(AbstractHostCollection.class);
    private static final AbstractHostCollection EMPTY = new AbstractHostCollection(){};

    public static AbstractHostCollection empty() {
        return EMPTY;
    }

    public AbstractHostCollection() {
    }

    public AbstractHostCollection(java.util.Collection<Host> c) {
        super(c);
    }

    public void sort() {
        this.sort(new Comparator<Host>(){

            @Override
            public int compare(Host o1, Host o2) {
                return new DefaultLexicographicOrderComparator().compare(BookmarkNameProvider.toString(o1), BookmarkNameProvider.toString(o2));
            }
        });
    }

    public Map<String, List<Host>> groups(HostFilter filter) {
        HashMap<String, List<Host>> labels = new HashMap<String, List<Host>>();
        for (Host host : this.stream().filter(filter::accept).collect(Collectors.toList())) {
            if (host.getLabels().isEmpty()) {
                List list = labels.getOrDefault("", new ArrayList());
                list.add(host);
                labels.put("", list);
                continue;
            }
            for (String label : host.getLabels()) {
                List list = labels.getOrDefault(label, new ArrayList());
                list.add(host);
                labels.put(label, list);
            }
        }
        return labels;
    }

    @Override
    public boolean allowsAdd() {
        return true;
    }

    @Override
    public boolean allowsDelete() {
        return true;
    }

    @Override
    public boolean allowsEdit() {
        return true;
    }

    public boolean find(Host bookmark) {
        return this.stream().anyMatch(h -> h.compareTo(bookmark) == 0);
    }

    public Host lookup(String uuid) {
        return this.stream().filter(h -> h.getUuid().equals(uuid)).findFirst().orElse(null);
    }

    public String getComment(Host h) {
        if (StringUtils.isNotBlank((CharSequence)h.getComment())) {
            return StringUtils.remove((String)StringUtils.remove((String)h.getComment(), (char)'\n'), (char)'\r');
        }
        return null;
    }
}

