/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.openstack;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.cdn.Distribution;
import ch.cyberduck.core.cdn.features.Purge;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.openstack.SwiftExceptionMappingService;
import ch.cyberduck.core.openstack.SwiftRegionService;
import ch.cyberduck.core.openstack.SwiftSession;
import ch.iterate.openstack.swift.Client;
import ch.iterate.openstack.swift.exception.GenericException;
import java.io.IOException;
import java.util.List;

public class SwiftDistributionPurgeFeature
implements Purge {
    private final SwiftSession session;
    private final PathContainerService containerService = new PathContainerService();
    private final SwiftRegionService regionService;

    public SwiftDistributionPurgeFeature(SwiftSession session) {
        this(session, new SwiftRegionService(session));
    }

    public SwiftDistributionPurgeFeature(SwiftSession session, SwiftRegionService regionService) {
        this.session = session;
        this.regionService = regionService;
    }

    public void invalidate(Path container, Distribution.Method method, List<Path> files, LoginCallback prompt) throws BackgroundException {
        try {
            for (Path file : files) {
                if (this.containerService.isContainer(file)) {
                    ((Client)this.session.getClient()).purgeCDNContainer(this.regionService.lookup(this.containerService.getContainer(file)), container.getName(), null);
                    continue;
                }
                ((Client)this.session.getClient()).purgeCDNObject(this.regionService.lookup(this.containerService.getContainer(file)), container.getName(), this.containerService.getKey(file), null);
            }
        }
        catch (GenericException e) {
            throw new SwiftExceptionMappingService().map("Cannot write CDN configuration", e);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Cannot write CDN configuration", (Throwable)e);
        }
    }
}

