/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.spectra;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.s3.S3PathContainerService;
import ch.cyberduck.core.spectra.SpectraClientBuilder;
import ch.cyberduck.core.spectra.SpectraExceptionMappingService;
import ch.cyberduck.core.spectra.SpectraSession;
import com.spectralogic.ds3client.Ds3Client;
import com.spectralogic.ds3client.commands.HeadObjectRequest;
import com.spectralogic.ds3client.commands.HeadObjectResponse;
import com.spectralogic.ds3client.networking.FailedRequestException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.log4j.Logger;
import org.jets3t.service.impl.rest.httpclient.RestStorageService;

public class SpectraAttributesFinderFeature
implements AttributesFinder {
    private static final Logger log = Logger.getLogger(SpectraAttributesFinderFeature.class);
    private final SpectraSession session;
    private final PathContainerService containerService = new S3PathContainerService();

    public SpectraAttributesFinderFeature(SpectraSession session) {
        this.session = session;
    }

    public PathAttributes find(Path file) throws BackgroundException {
        if (file.isRoot()) {
            return PathAttributes.EMPTY;
        }
        if (this.containerService.isContainer(file)) {
            return PathAttributes.EMPTY;
        }
        return this.toAttributes(this.details(file));
    }

    protected HeadObjectResponse details(Path file) throws BackgroundException {
        try {
            Ds3Client client = new SpectraClientBuilder().wrap((RestStorageService)this.session.getClient(), this.session.getHost());
            HeadObjectResponse response = client.headObject(new HeadObjectRequest(this.containerService.getContainer(file).getName(), this.containerService.getKey(file)));
            switch (response.getStatus()) {
                case DOESNTEXIST: {
                    throw new NotfoundException(file.getAbsolute());
                }
            }
            return response;
        }
        catch (FailedRequestException e) {
            throw new SpectraExceptionMappingService().map("Failure to read attributes of {0}", e, file);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Failure to read attributes of {0}", (Throwable)e, file);
        }
    }

    public PathAttributes toAttributes(HeadObjectResponse object) {
        PathAttributes attributes = new PathAttributes();
        attributes.setSize(object.getObjectSize());
        HashMap<String, String> metadata = new HashMap<String, String>();
        for (String key : object.getMetadata().keys()) {
            for (String value : object.getMetadata().get(key)) {
                metadata.put(key, value);
            }
        }
        attributes.setMetadata(metadata);
        for (Map.Entry checksum : object.getBlobChecksums().entrySet()) {
            attributes.setChecksum(Checksum.parse((String)Hex.encodeHexString((byte[])Base64.decodeBase64((String)((String)checksum.getValue())))));
        }
        return attributes;
    }
}

