/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sftp.openssh.config.fnmatch;

import ch.cyberduck.core.sftp.openssh.config.errors.InvalidPatternException;
import ch.cyberduck.core.sftp.openssh.config.errors.NoClosingBracketException;
import ch.cyberduck.core.sftp.openssh.config.fnmatch.AbstractHead;
import ch.cyberduck.core.sftp.openssh.config.fnmatch.CharacterHead;
import ch.cyberduck.core.sftp.openssh.config.fnmatch.GroupHead;
import ch.cyberduck.core.sftp.openssh.config.fnmatch.Head;
import ch.cyberduck.core.sftp.openssh.config.fnmatch.LastHead;
import ch.cyberduck.core.sftp.openssh.config.fnmatch.RestrictedWildCardHead;
import ch.cyberduck.core.sftp.openssh.config.fnmatch.WildCardHead;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileNameMatcher {
    static final List<Head> EMPTY_HEAD_LIST = Collections.emptyList();
    private static final Pattern characterClassStartPattern = Pattern.compile("\\[[.:=]");
    private final List<Head> headsStartValue;
    private List<Head> heads;
    private List<Head> listForLocalUseage;

    private FileNameMatcher(List<Head> headsStartValue) {
        this(headsStartValue, headsStartValue);
    }

    private FileNameMatcher(List<Head> headsStartValue, List<Head> heads) {
        this.headsStartValue = headsStartValue;
        this.heads = new ArrayList<Head>(heads.size());
        this.heads.addAll(heads);
        this.listForLocalUseage = new ArrayList<Head>(heads.size());
    }

    public FileNameMatcher(String patternString, Character invalidWildgetCharacter) throws InvalidPatternException {
        this(FileNameMatcher.createHeadsStartValues(patternString, invalidWildgetCharacter));
    }

    public FileNameMatcher(FileNameMatcher other) {
        this(other.headsStartValue, other.heads);
    }

    private static List<Head> createHeadsStartValues(String patternString, Character invalidWildgetCharacter) throws InvalidPatternException {
        List<AbstractHead> allHeads = FileNameMatcher.parseHeads(patternString, invalidWildgetCharacter);
        ArrayList<Head> nextHeadsSuggestion = new ArrayList<Head>(2);
        nextHeadsSuggestion.add(LastHead.INSTANCE);
        for (int i = allHeads.size() - 1; i >= 0; --i) {
            AbstractHead head = allHeads.get(i);
            if (head.isStar()) {
                nextHeadsSuggestion.add(head);
                head.setNewHeads(nextHeadsSuggestion);
                continue;
            }
            head.setNewHeads(nextHeadsSuggestion);
            nextHeadsSuggestion = new ArrayList(2);
            nextHeadsSuggestion.add(head);
        }
        return nextHeadsSuggestion;
    }

    private static int findGroupEnd(int indexOfStartBracket, String pattern) throws InvalidPatternException {
        int firstValidCharClassIndex = indexOfStartBracket + 1;
        int firstValidEndBracketIndex = indexOfStartBracket + 2;
        if (indexOfStartBracket + 1 >= pattern.length()) {
            throw new NoClosingBracketException(indexOfStartBracket, "[", "]", pattern);
        }
        if (pattern.charAt(firstValidCharClassIndex) == '!') {
            ++firstValidCharClassIndex;
            ++firstValidEndBracketIndex;
        }
        Matcher charClassStartMatcher = characterClassStartPattern.matcher(pattern);
        int groupEnd = -1;
        while (groupEnd == -1) {
            int possibleGroupEnd = pattern.indexOf(93, firstValidEndBracketIndex);
            if (possibleGroupEnd == -1) {
                throw new NoClosingBracketException(indexOfStartBracket, "[", "]", pattern);
            }
            boolean foundCharClass = charClassStartMatcher.find(firstValidCharClassIndex);
            if (foundCharClass && charClassStartMatcher.start() < possibleGroupEnd) {
                int classStartIndex;
                String classStart = charClassStartMatcher.group(0);
                String classEnd = classStart.charAt(1) + "]";
                int classEndIndex = pattern.indexOf(classEnd, (classStartIndex = charClassStartMatcher.start()) + 2);
                if (classEndIndex == -1) {
                    throw new NoClosingBracketException(classStartIndex, classStart, classEnd, pattern);
                }
                firstValidEndBracketIndex = firstValidCharClassIndex = classEndIndex + 2;
                continue;
            }
            groupEnd = possibleGroupEnd;
        }
        return groupEnd;
    }

    private static List<AbstractHead> parseHeads(String pattern, Character invalidWildgetCharacter) throws InvalidPatternException {
        int currentIndex = 0;
        ArrayList<AbstractHead> heads = new ArrayList<AbstractHead>();
        while (currentIndex < pattern.length()) {
            String patternPart;
            int groupStart = pattern.indexOf(91, currentIndex);
            if (groupStart == -1) {
                patternPart = pattern.substring(currentIndex);
                heads.addAll(FileNameMatcher.createSimpleHeads(patternPart, invalidWildgetCharacter));
                currentIndex = pattern.length();
                continue;
            }
            patternPart = pattern.substring(currentIndex, groupStart);
            heads.addAll(FileNameMatcher.createSimpleHeads(patternPart, invalidWildgetCharacter));
            int groupEnd = FileNameMatcher.findGroupEnd(groupStart, pattern);
            String groupPart = pattern.substring(groupStart + 1, groupEnd);
            heads.add(new GroupHead(groupPart, pattern));
            currentIndex = groupEnd + 1;
        }
        return heads;
    }

    private static List<AbstractHead> createSimpleHeads(String patternPart, Character invalidWildgetCharacter) {
        ArrayList<AbstractHead> heads = new ArrayList<AbstractHead>(patternPart.length());
        block4: for (int i = 0; i < patternPart.length(); ++i) {
            char c = patternPart.charAt(i);
            switch (c) {
                case '*': {
                    AbstractHead head = FileNameMatcher.createWildCardHead(invalidWildgetCharacter, true);
                    heads.add(head);
                    continue block4;
                }
                case '?': {
                    AbstractHead head = FileNameMatcher.createWildCardHead(invalidWildgetCharacter, false);
                    heads.add(head);
                    continue block4;
                }
                default: {
                    AbstractHead head = new CharacterHead(c);
                    heads.add(head);
                }
            }
        }
        return heads;
    }

    private static AbstractHead createWildCardHead(Character invalidWildgetCharacter, boolean star) {
        if (invalidWildgetCharacter != null) {
            return new RestrictedWildCardHead(invalidWildgetCharacter.charValue(), star);
        }
        return new WildCardHead(star);
    }

    private void extendStringToMatchByOneCharacter(char c) {
        List<Head> newHeads = this.listForLocalUseage;
        newHeads.clear();
        List<Head> lastAddedHeads = null;
        for (Head head : this.heads) {
            List<Head> headsToAdd = head.getNextHeads(c);
            if (headsToAdd.equals(lastAddedHeads)) continue;
            newHeads.addAll(headsToAdd);
            lastAddedHeads = headsToAdd;
        }
        this.listForLocalUseage = this.heads;
        this.heads = newHeads;
    }

    public void append(String stringToMatch) {
        for (int i = 0; i < stringToMatch.length(); ++i) {
            char c = stringToMatch.charAt(i);
            this.extendStringToMatchByOneCharacter(c);
        }
    }

    public void reset() {
        this.heads.clear();
        this.heads.addAll(this.headsStartValue);
    }

    public FileNameMatcher createMatcherForSuffix() {
        ArrayList<Head> copyOfHeads = new ArrayList<Head>(this.heads.size());
        copyOfHeads.addAll(this.heads);
        return new FileNameMatcher(copyOfHeads);
    }

    public boolean isMatch() {
        ListIterator<Head> headIterator = this.heads.listIterator(this.heads.size());
        while (headIterator.hasPrevious()) {
            Head head = headIterator.previous();
            if (head != LastHead.INSTANCE) continue;
            return true;
        }
        return false;
    }

    public boolean canAppendMatch() {
        for (Head head : this.heads) {
            if (head == LastHead.INSTANCE) continue;
            return true;
        }
        return false;
    }
}

