/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.binding.foundation.FoundationKitFunctions;
import ch.cyberduck.binding.foundation.NSArray;
import ch.cyberduck.binding.foundation.NSData;
import ch.cyberduck.binding.foundation.NSMutableArray;
import ch.cyberduck.core.CertificateIdentityCallback;
import ch.cyberduck.core.CertificateStore;
import ch.cyberduck.core.CertificateTrustCallback;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.keychain.SecCertificateRef;
import ch.cyberduck.core.keychain.SecIdentityRef;
import ch.cyberduck.core.keychain.SecPolicyRef;
import ch.cyberduck.core.keychain.SecTrustRef;
import ch.cyberduck.core.keychain.SecTrustResultType;
import ch.cyberduck.core.keychain.SecurityFunctions;
import ch.cyberduck.core.ssl.CertificateStoreX509KeyManager;
import ch.cyberduck.core.ssl.DEREncoder;
import ch.cyberduck.core.ssl.KeychainX509KeyManager;
import com.sun.jna.PointerType;
import com.sun.jna.platform.mac.CoreFoundation;
import com.sun.jna.ptr.PointerByReference;
import java.io.ByteArrayInputStream;
import java.security.Principal;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.rococoa.cocoa.foundation.NSUInteger;

public final class KeychainCertificateStore
implements CertificateStore {
    private static final Logger log = Logger.getLogger(KeychainCertificateStore.class);

    public boolean verify(CertificateTrustCallback prompt, String hostname, List<X509Certificate> certificates) throws CertificateException {
        SecTrustResultType trustResultType;
        if (certificates.isEmpty()) {
            return false;
        }
        SecPolicyRef policyRef = SecurityFunctions.library.SecPolicyCreateSSL(true, hostname);
        PointerByReference reference = new PointerByReference();
        int err = SecurityFunctions.library.SecTrustCreateWithCertificates(KeychainCertificateStore.toDEREncodedCertificates(certificates), policyRef, reference);
        if (0 != err) {
            log.error((Object)String.format("SecTrustCreateWithCertificates returning error %d", err));
            return false;
        }
        SecTrustRef trustRef = new SecTrustRef(reference.getValue());
        err = SecurityFunctions.library.SecTrustEvaluate(trustRef, trustResultType = new SecTrustResultType());
        if (0 != err) {
            log.error((Object)String.format("SecTrustEvaluate returning error %d", err));
            return false;
        }
        FoundationKitFunctions.library.CFRelease((CoreFoundation.CFTypeRef)trustRef);
        FoundationKitFunctions.library.CFRelease((CoreFoundation.CFTypeRef)policyRef);
        switch (trustResultType.getValue()) {
            case 1: 
            case 4: {
                return true;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Evaluated recoverable trust result failure " + trustResultType.getValue()));
        }
        try {
            prompt.prompt(hostname, certificates);
            return true;
        }
        catch (ConnectionCanceledException e) {
            return false;
        }
    }

    public X509Certificate choose(CertificateIdentityCallback prompt, String[] keyTypes, Principal[] issuers, Host bookmark) throws ConnectionCanceledException {
        ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
        CertificateStoreX509KeyManager manager = new KeychainX509KeyManager(prompt, bookmark, (CertificateStore)this).init();
        String[] aliases = manager.getClientAliases(keyTypes, issuers);
        if (null == aliases) {
            throw new ConnectionCanceledException(String.format("No certificate matching issuer %s found", Arrays.toString(issuers)));
        }
        for (String alias : aliases) {
            certificates.add(manager.getCertificate(alias, keyTypes, issuers));
        }
        return prompt.prompt(bookmark.getHostname(), certificates);
    }

    public static X509Certificate toX509Certificate(SecIdentityRef identityRef) {
        PointerByReference reference = new PointerByReference();
        int err = SecurityFunctions.library.SecIdentityCopyCertificate(identityRef, reference);
        if (0 != err) {
            log.error((Object)String.format("SecIdentityCopyCertificate returning error %d", err));
            return null;
        }
        SecCertificateRef certificateRef = new SecCertificateRef(reference.getValue());
        try {
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            NSData dataRef = SecurityFunctions.library.SecCertificateCopyData(certificateRef);
            X509Certificate selected = (X509Certificate)factory.generateCertificate(new ByteArrayInputStream(Base64.decodeBase64((String)dataRef.base64Encoding())));
            if (log.isDebugEnabled()) {
                log.info((Object)String.format("Selected certificate %s", selected));
            }
            FoundationKitFunctions.library.CFRelease((CoreFoundation.CFTypeRef)certificateRef);
            return selected;
        }
        catch (CertificateException e) {
            log.error((Object)String.format("Error %s creating certificate from reference", e));
            return null;
        }
    }

    public static NSArray toDEREncodedCertificates(List<X509Certificate> certificates) {
        try {
            Object[] objectArray = new DEREncoder().encode(certificates);
        }
        catch (CertificateException e) {
            log.error((Object)String.format("Failure %s DER encoding certificates %s", e, certificates));
            return NSArray.array();
        }
        NSMutableArray certs = NSMutableArray.arrayWithCapacity((NSUInteger)new NSUInteger((long)certificates.size()));
        for (X509Certificate certificate : certificates) {
            try {
                SecCertificateRef certificateRef = SecurityFunctions.library.SecCertificateCreateWithData(null, NSData.dataWithBase64EncodedString((String)Base64.encodeBase64String((byte[])certificate.getEncoded())));
                if (null == certificateRef) {
                    log.error((Object)String.format("Error creating converting from ASN.1 DER encoded certificate %s", certificate));
                    continue;
                }
                certs.addObject((PointerType)certificateRef);
            }
            catch (CertificateEncodingException e) {
                log.error((Object)String.format("Failure %s retrieving encoded  certificate", e));
            }
        }
        return certs;
    }
}

