/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.cryptomator.features;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Home;
import ch.cyberduck.core.features.Vault;

public class CryptoHomeFeature
implements Home {
    private final Session<?> session;
    private final Home delegate;
    private final Vault vault;

    public CryptoHomeFeature(Session<?> session, Home delegate, Vault vault) {
        this.session = session;
        this.delegate = delegate;
        this.vault = vault;
    }

    public Path find() throws BackgroundException {
        return this.delegate.find();
    }

    public Path find(Path workdir, String path) {
        try {
            return this.delegate.find(this.vault.encrypt(this.session, workdir), path);
        }
        catch (BackgroundException ignored) {
            return this.delegate.find(workdir, path);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CryptoHomeFeature{");
        sb.append("delegate=").append(this.delegate);
        sb.append('}');
        return sb.toString();
    }
}

