/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Lock;
import ch.cyberduck.core.onedrive.GraphSession;
import ch.cyberduck.core.onedrive.SharepointSession;
import ch.cyberduck.core.onedrive.features.GraphLockFeature;
import ch.cyberduck.core.ssl.X509KeyManager;
import ch.cyberduck.core.ssl.X509TrustManager;
import java.util.ArrayDeque;
import java.util.Deque;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.nuxeo.onedrive.client.OneDriveAPI;
import org.nuxeo.onedrive.client.types.Drive;
import org.nuxeo.onedrive.client.types.DriveItem;
import org.nuxeo.onedrive.client.types.GroupItem;
import org.nuxeo.onedrive.client.types.Site;

public abstract class AbstractSharepointSession
extends GraphSession {
    private static final Logger log = Logger.getLogger(SharepointSession.class);

    public AbstractSharepointSession(Host host, X509TrustManager trust, X509KeyManager key) {
        super(host, trust, key);
    }

    public abstract boolean isSingleSite();

    public abstract Site getSite(Path var1) throws BackgroundException;

    public abstract GroupItem getGroup(Path var1) throws BackgroundException;

    @Override
    public DriveItem toItem(Path file, boolean resolveLastItem) throws BackgroundException {
        String itemId;
        String driveId;
        String versionId = this.fileIdProvider.getFileid(file, (ListProgressListener)new DisabledListProgressListener());
        if (StringUtils.isEmpty((CharSequence)versionId)) {
            throw new NotfoundException(String.format("Version ID for %s is empty", file.getAbsolute()));
        }
        String[] idParts = versionId.split(String.valueOf('/'));
        if (idParts.length == 1) {
            return new Drive((OneDriveAPI)this.getClient(), idParts[0]).getRoot();
        }
        if (idParts.length == 2 || !resolveLastItem) {
            driveId = idParts[0];
            itemId = idParts[1];
        } else if (idParts.length == 4) {
            driveId = idParts[2];
            itemId = idParts[3];
        } else {
            throw new NotfoundException(file.getAbsolute());
        }
        Drive drive = new Drive((OneDriveAPI)this.getClient(), driveId);
        if (file.getType().contains(AbstractPath.Type.file)) {
            return new DriveItem(drive, itemId);
        }
        if (file.getType().contains(AbstractPath.Type.directory)) {
            return new DriveItem(drive, itemId);
        }
        if (file.getType().contains(AbstractPath.Type.placeholder)) {
            return new DriveItem(drive, itemId);
        }
        throw new NotfoundException(file.getAbsolute());
    }

    @Override
    public <T> T _getFeature(Class<T> type) {
        if (type == Lock.class) {
            return (T)new GraphLockFeature(this);
        }
        return super._getFeature(type);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isAccessible(Path file, boolean container) {
        if (file.isRoot()) {
            return false;
        }
        GraphSession.ContainerItem containerItem = this.getContainer(file);
        if (!containerItem.isDefined()) {
            return false;
        }
        if (!containerItem.isDrive()) return false;
        if (container) return true;
        if (containerItem.getContainerPath().map(arg_0 -> ((Path)file).equals(arg_0)).orElse(false) != false) return false;
        return true;
    }

    protected Deque<Path> decompose(Path file) {
        ArrayDeque<Path> walk = new ArrayDeque<Path>();
        Path next = file;
        while (!next.isRoot()) {
            walk.push(next);
            next = next.getParent();
        }
        return walk;
    }
}

