/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.model;

import ch.cyberduck.core.sds.io.swagger.client.model.ObjectExpiration;
import ch.cyberduck.core.sds.io.swagger.client.model.UserAuthData;
import ch.cyberduck.core.sds.io.swagger.client.model.UserAuthMethod;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="Request model for creating an user")
public class CreateUserRequest {
    @JsonProperty(value="firstName")
    private String firstName = null;
    @JsonProperty(value="lastName")
    private String lastName = null;
    @JsonProperty(value="userName")
    private String userName = null;
    @JsonProperty(value="phone")
    private String phone = null;
    @JsonProperty(value="expiration")
    private ObjectExpiration expiration = null;
    @JsonProperty(value="receiverLanguage")
    private String receiverLanguage = null;
    @JsonProperty(value="email")
    private String email = null;
    @JsonProperty(value="notifyUser")
    private Boolean notifyUser = null;
    @JsonProperty(value="authData")
    private UserAuthData authData = null;
    @JsonProperty(value="isNonmemberViewer")
    private Boolean isNonmemberViewer = null;
    @JsonProperty(value="title")
    private String title = null;
    @JsonProperty(value="password")
    private String password = null;
    @JsonProperty(value="login")
    private String login = null;
    @JsonProperty(value="authMethods")
    private List<UserAuthMethod> authMethods = null;
    @JsonProperty(value="needsToChangePassword")
    private Boolean needsToChangePassword = null;
    @JsonProperty(value="gender")
    private String gender = "n";

    public CreateUserRequest firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    @Schema(required=true, description="User first name")
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public CreateUserRequest lastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    @Schema(required=true, description="User last name")
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public CreateUserRequest userName(String userName) {
        this.userName = userName;
        return this;
    }

    @Schema(description="&#128640; Since v4.13.0  Username")
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public CreateUserRequest phone(String phone) {
        this.phone = phone;
        return this;
    }

    @Schema(description="Phone number")
    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public CreateUserRequest expiration(ObjectExpiration expiration) {
        this.expiration = expiration;
        return this;
    }

    @Schema(description="")
    public ObjectExpiration getExpiration() {
        return this.expiration;
    }

    public void setExpiration(ObjectExpiration expiration) {
        this.expiration = expiration;
    }

    public CreateUserRequest receiverLanguage(String receiverLanguage) {
        this.receiverLanguage = receiverLanguage;
        return this;
    }

    @Schema(description="IETF language tag")
    public String getReceiverLanguage() {
        return this.receiverLanguage;
    }

    public void setReceiverLanguage(String receiverLanguage) {
        this.receiverLanguage = receiverLanguage;
    }

    public CreateUserRequest email(String email) {
        this.email = email;
        return this;
    }

    @Schema(description="Email ")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public CreateUserRequest notifyUser(Boolean notifyUser) {
        this.notifyUser = notifyUser;
        return this;
    }

    @Schema(description="&#128640; Since v4.9.0  Notify user about his new account  * default: `true` for `basic` auth type  * default: `false` for `active_directory`, `openid` and `radius` auth types")
    public Boolean isNotifyUser() {
        return this.notifyUser;
    }

    public void setNotifyUser(Boolean notifyUser) {
        this.notifyUser = notifyUser;
    }

    public CreateUserRequest authData(UserAuthData authData) {
        this.authData = authData;
        return this;
    }

    @Schema(description="")
    public UserAuthData getAuthData() {
        return this.authData;
    }

    public void setAuthData(UserAuthData authData) {
        this.authData = authData;
    }

    public CreateUserRequest isNonmemberViewer(Boolean isNonmemberViewer) {
        this.isNonmemberViewer = isNonmemberViewer;
        return this;
    }

    @Schema(description="&#128640; Since v4.12.0  Determines whether user has the role NONMEMBER_VIEWER")
    public Boolean isIsNonmemberViewer() {
        return this.isNonmemberViewer;
    }

    public void setIsNonmemberViewer(Boolean isNonmemberViewer) {
        this.isNonmemberViewer = isNonmemberViewer;
    }

    public CreateUserRequest title(String title) {
        this.title = title;
        return this;
    }

    @Schema(description="&#128679; Deprecated since v4.18.0  Job title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public CreateUserRequest password(String password) {
        this.password = password;
        return this;
    }

    @Schema(description="&#128679; Deprecated since v4.13.0  An initial password may be preset  use `authData` instead")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public CreateUserRequest login(String login) {
        this.login = login;
        return this;
    }

    @Schema(description="&#128679; Deprecated since v4.13.0  User login name")
    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public CreateUserRequest authMethods(List<UserAuthMethod> authMethods) {
        this.authMethods = authMethods;
        return this;
    }

    public CreateUserRequest addAuthMethodsItem(UserAuthMethod authMethodsItem) {
        if (this.authMethods == null) {
            this.authMethods = new ArrayList<UserAuthMethod>();
        }
        this.authMethods.add(authMethodsItem);
        return this;
    }

    @Schema(description="&#128679; Deprecated since v4.13.0  Authentication methods:  * `sql`  * `active_directory`  * `radius`  * `openid`  use `authData` instead")
    public List<UserAuthMethod> getAuthMethods() {
        return this.authMethods;
    }

    public void setAuthMethods(List<UserAuthMethod> authMethods) {
        this.authMethods = authMethods;
    }

    public CreateUserRequest needsToChangePassword(Boolean needsToChangePassword) {
        this.needsToChangePassword = needsToChangePassword;
        return this;
    }

    @Schema(description="&#128679; Deprecated since v4.13.0  Determines whether user has to change his / her initial password.  use `authDate.mustChangePassword` instead")
    public Boolean isNeedsToChangePassword() {
        return this.needsToChangePassword;
    }

    public void setNeedsToChangePassword(Boolean needsToChangePassword) {
        this.needsToChangePassword = needsToChangePassword;
    }

    public CreateUserRequest gender(String gender) {
        this.gender = gender;
        return this;
    }

    @Schema(description="&#128679; Deprecated since v4.12.0  Gender  Do NOT use `gender`! It will be ignored.")
    public String getGender() {
        return this.gender;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateUserRequest createUserRequest = (CreateUserRequest)o;
        return Objects.equals(this.firstName, createUserRequest.firstName) && Objects.equals(this.lastName, createUserRequest.lastName) && Objects.equals(this.userName, createUserRequest.userName) && Objects.equals(this.phone, createUserRequest.phone) && Objects.equals(this.expiration, createUserRequest.expiration) && Objects.equals(this.receiverLanguage, createUserRequest.receiverLanguage) && Objects.equals(this.email, createUserRequest.email) && Objects.equals(this.notifyUser, createUserRequest.notifyUser) && Objects.equals(this.authData, createUserRequest.authData) && Objects.equals(this.isNonmemberViewer, createUserRequest.isNonmemberViewer) && Objects.equals(this.title, createUserRequest.title) && Objects.equals(this.password, createUserRequest.password) && Objects.equals(this.login, createUserRequest.login) && Objects.equals(this.authMethods, createUserRequest.authMethods) && Objects.equals(this.needsToChangePassword, createUserRequest.needsToChangePassword) && Objects.equals(this.gender, createUserRequest.gender);
    }

    public int hashCode() {
        return Objects.hash(this.firstName, this.lastName, this.userName, this.phone, this.expiration, this.receiverLanguage, this.email, this.notifyUser, this.authData, this.isNonmemberViewer, this.title, this.password, this.login, this.authMethods, this.needsToChangePassword, this.gender);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateUserRequest {\n");
        sb.append("    firstName: ").append(this.toIndentedString(this.firstName)).append("\n");
        sb.append("    lastName: ").append(this.toIndentedString(this.lastName)).append("\n");
        sb.append("    userName: ").append(this.toIndentedString(this.userName)).append("\n");
        sb.append("    phone: ").append(this.toIndentedString(this.phone)).append("\n");
        sb.append("    expiration: ").append(this.toIndentedString(this.expiration)).append("\n");
        sb.append("    receiverLanguage: ").append(this.toIndentedString(this.receiverLanguage)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    notifyUser: ").append(this.toIndentedString(this.notifyUser)).append("\n");
        sb.append("    authData: ").append(this.toIndentedString(this.authData)).append("\n");
        sb.append("    isNonmemberViewer: ").append(this.toIndentedString(this.isNonmemberViewer)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    login: ").append(this.toIndentedString(this.login)).append("\n");
        sb.append("    authMethods: ").append(this.toIndentedString(this.authMethods)).append("\n");
        sb.append("    needsToChangePassword: ").append(this.toIndentedString(this.needsToChangePassword)).append("\n");
        sb.append("    gender: ").append(this.toIndentedString(this.gender)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

