/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.utils;

import java.net.URI;
import java.net.URISyntaxException;
import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.exception.InvalidIRODSUriException;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.exception.JargonRuntimeException;
import org.irods.jargon.core.utils.IRODSUriUserInfo;
import org.irods.jargon.core.utils.URIUserParts;

public class IRODSUriUtils {
    private static final String SCHEME = "irods";
    private static final String SCHEME_TERMINUS = "://";
    private static final String USER_INFO_TERMINUS = "@";
    private static final String PORT_INDICATOR = ":";
    private static final String PATH_SEPARATOR = "/";

    public static IRODSUriUserInfo getUserInfo(URI irodsURI) throws InvalidIRODSUriException {
        if (!IRODSUriUtils.isIRODSURIScheme(irodsURI)) {
            throw new InvalidIRODSUriException(irodsURI);
        }
        return IRODSUriUserInfo.fromString(irodsURI.getRawUserInfo());
    }

    public static String getUserName(URI irodsURI) throws InvalidIRODSUriException {
        IRODSUriUserInfo info = IRODSUriUtils.getUserInfo(irodsURI);
        return info == null ? null : info.getUserName();
    }

    public static String getZone(URI irodsURI) throws InvalidIRODSUriException {
        IRODSUriUserInfo info = IRODSUriUtils.getUserInfo(irodsURI);
        return info == null ? null : info.getZone();
    }

    public static String getPassword(URI irodsURI) throws InvalidIRODSUriException {
        IRODSUriUserInfo info = IRODSUriUtils.getUserInfo(irodsURI);
        return info == null ? null : info.getPassword();
    }

    @Deprecated
    public static String getUserNameFromURI(URI irodsURI) {
        IRODSUriUserInfo info = IRODSUriUserInfo.fromString(irodsURI.getRawUserInfo());
        return info == null ? null : info.getUserName();
    }

    @Deprecated
    protected static URIUserParts getURIUserPartsFromUserInfo(URI irodsURI) {
        String userInfo = irodsURI.getUserInfo();
        if (userInfo == null || userInfo.isEmpty()) {
            return null;
        }
        int indexColon = userInfo.indexOf(PORT_INDICATOR);
        int indexDot = userInfo.indexOf(".");
        String userName = null;
        if (indexDot != -1 && (userName = userInfo.substring(0, indexDot)).isEmpty()) {
            userName = null;
        }
        String password = null;
        String zone = null;
        if (userName != null && indexColon != -1 && (password = userInfo.substring(indexColon + 1)).isEmpty()) {
            password = null;
        }
        if (indexColon == -1 && indexDot == -1) {
            if (!userInfo.isEmpty()) {
                zone = userInfo;
            }
        } else {
            int substrStart = 0;
            int substrEnd = userInfo.length();
            if (indexDot != -1) {
                substrStart = indexDot + 1;
            }
            if (indexColon != -1) {
                substrEnd = indexColon;
            }
            zone = userInfo.substring(substrStart, substrEnd);
        }
        URIUserParts uriUserParts = new URIUserParts();
        uriUserParts.setPassword(password);
        uriUserParts.setUserName(userName);
        uriUserParts.setZone(zone);
        return uriUserParts;
    }

    @Deprecated
    public static String getPasswordFromURI(URI irodsURI) {
        IRODSUriUserInfo info = IRODSUriUserInfo.fromString(irodsURI.getRawUserInfo());
        return info == null ? null : info.getPassword();
    }

    @Deprecated
    public static String getZoneFromURI(URI irodsURI) {
        IRODSUriUserInfo info = IRODSUriUserInfo.fromString(irodsURI.getRawUserInfo());
        return info == null ? null : info.getZone();
    }

    public static String getHostFromURI(URI uri) {
        return uri.getHost();
    }

    public static int getPortFromURI(URI uri) {
        return uri.getPort();
    }

    public static String getAbsolutePathFromURI(URI uri) {
        return uri.getPath();
    }

    public static IRODSAccount getIRODSAccountFromURI(URI irodsURI) throws JargonException {
        if (!IRODSUriUtils.isIRODSURIScheme(irodsURI)) {
            throw new InvalidIRODSUriException(irodsURI);
        }
        IRODSUriUserInfo info = IRODSUriUtils.getUserInfo(irodsURI);
        if (info == null || info.getPassword() == null || info.getZone() == null) {
            throw new JargonException("No user information in URI, cannot create iRODS account");
        }
        String home = PATH_SEPARATOR + info.getZone() + PATH_SEPARATOR + "home" + PATH_SEPARATOR + info.getUserName();
        return IRODSAccount.instance(irodsURI.getHost(), irodsURI.getPort(), info.getUserName(), info.getPassword(), home, info.getZone(), "");
    }

    public static boolean isIRODSURIScheme(URI irodsURI) {
        return SCHEME.equals(irodsURI.getScheme());
    }

    public static URI buildBaseURI(String host, int port, IRODSUriUserInfo userInfo) {
        try {
            StringBuilder uriBuilder = new StringBuilder();
            uriBuilder.append(SCHEME).append(SCHEME_TERMINUS);
            if (userInfo != null) {
                uriBuilder.append(userInfo).append(USER_INFO_TERMINUS);
            }
            uriBuilder.append(host).append(PORT_INDICATOR).append(port);
            uriBuilder.append(PATH_SEPARATOR);
            return new URI(uriBuilder.toString());
        }
        catch (URISyntaxException e) {
            throw new JargonRuntimeException(e);
        }
    }

    public static URI buildBaseURI(String host, int port, String username) {
        IRODSUriUserInfo info = IRODSUriUserInfo.instance(username, null, null);
        return IRODSUriUtils.buildBaseURI(host, port, info);
    }

    public static URI buildURI(String host, int port, IRODSUriUserInfo userInfo, String absPath) {
        try {
            URI base = IRODSUriUtils.buildBaseURI(host, port, userInfo);
            return base.resolve(new URI(null, absPath, null));
        }
        catch (URISyntaxException e) {
            throw new JargonRuntimeException(e);
        }
    }

    public static URI buildURI(String host, int port, String username, String absPath) {
        try {
            URI base = IRODSUriUtils.buildBaseURI(host, port, username);
            return base.resolve(new URI(null, absPath, null));
        }
        catch (URISyntaxException e) {
            throw new JargonRuntimeException(e);
        }
    }

    public static URI buildAnonymousURI(String host, int port, String absPath) {
        if (absPath == null || absPath.isEmpty()) {
            throw new IllegalArgumentException("null or empty path");
        }
        try {
            return new URI(SCHEME, null, host, port, absPath, null, null);
        }
        catch (URISyntaxException e) {
            throw new JargonRuntimeException(e);
        }
    }

    public static URI buildURIForAnAccountAndPath(IRODSAccount irodsAccount, String irodsPath) {
        if (irodsAccount == null) {
            throw new IllegalArgumentException("null iRODSAccount");
        }
        if (irodsPath == null || irodsPath.isEmpty()) {
            throw new IllegalArgumentException("null or empty irodsAbsolutePath");
        }
        IRODSUriUserInfo info = IRODSUriUserInfo.unauthenticatedLocalInstance(irodsAccount.getUserName());
        String absPath = IRODSUriUtils.mkPathAbs(irodsAccount.getHomeDirectory(), irodsPath);
        return IRODSUriUtils.buildBaseURI(irodsAccount.getHost(), irodsAccount.getPort(), absPath, info);
    }

    public static URI buildURIForAnAccountWithNoUserInformationIncluded(IRODSAccount irodsAccount, String irodsPath) {
        if (irodsAccount == null) {
            throw new IllegalArgumentException("null iRODSAccount");
        }
        if (irodsPath == null || irodsPath.isEmpty()) {
            throw new IllegalArgumentException("null or empty irodsAbsolutePath");
        }
        String absPath = IRODSUriUtils.mkPathAbs(irodsAccount.getHomeDirectory(), irodsPath);
        return IRODSUriUtils.buildBaseURI(irodsAccount.getHost(), irodsAccount.getPort(), absPath, null);
    }

    private static URI buildBaseURI(String host, int port, String absPath, IRODSUriUserInfo userInfo) {
        try {
            StringBuilder uriBuilder = new StringBuilder();
            uriBuilder.append(SCHEME).append(SCHEME_TERMINUS);
            if (userInfo != null) {
                uriBuilder.append(userInfo).append(USER_INFO_TERMINUS);
            }
            uriBuilder.append(host).append(PORT_INDICATOR).append(port);
            uriBuilder.append(absPath);
            return new URI(uriBuilder.toString());
        }
        catch (URISyntaxException e) {
            throw new JargonRuntimeException(e);
        }
    }

    private static String mkPathAbs(String homeDir, String path) {
        if (path.startsWith(PATH_SEPARATOR)) {
            return path;
        }
        return homeDir + PATH_SEPARATOR + path;
    }
}

