/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.config;

import com.joyent.manta.config.ConfigContext;
import com.joyent.manta.config.EncryptionAuthenticationMode;
import com.joyent.manta.config.MetricReporterMode;
import com.joyent.manta.util.MantaUtils;
import java.util.Arrays;
import java.util.Base64;
import java.util.Map;

public class MapConfigContext
implements ConfigContext {
    public static final String MANTA_URL_KEY = "manta.url";
    public static final String MANTA_USER_KEY = "manta.user";
    public static final String MANTA_KEY_ID_KEY = "manta.key_id";
    public static final String MANTA_KEY_PATH_KEY = "manta.key_path";
    public static final String MANTA_TIMEOUT_KEY = "manta.timeout";
    public static final String MANTA_RETRIES_KEY = "manta.retries";
    public static final String MANTA_MAX_CONNS_KEY = "manta.max_connections";
    public static final String MANTA_PRIVATE_KEY_CONTENT_KEY = "manta.key_content";
    public static final String MANTA_PASSWORD_KEY = "manta.password";
    public static final String MANTA_HTTP_BUFFER_SIZE_KEY = "manta.http_buffer_size";
    public static final String MANTA_HTTPS_PROTOCOLS_KEY = "https.protocols";
    public static final String MANTA_HTTPS_CIPHERS_KEY = "https.cipherSuites";
    public static final String MANTA_TLS_INSECURE_KEY = "manta.tls_insecure";
    public static final String MANTA_NO_AUTH_KEY = "manta.no_auth";
    public static final String MANTA_NO_NATIVE_SIGS_KEY = "manta.disable_native_sigs";
    public static final String MANTA_TCP_SOCKET_TIMEOUT_KEY = "manta.tcp_socket_timeout";
    public static final String MANTA_CONNECTION_REQUEST_TIMEOUT_KEY = "manta.connection_request_timeout";
    public static final String MANTA_EXPECT_CONTINUE_TIMEOUT_KEY = "manta.expect_continue_timeout";
    public static final String MANTA_VERIFY_UPLOADS_KEY = "manta.verify_uploads";
    public static final String MANTA_UPLOAD_BUFFER_SIZE_KEY = "manta.upload_buffer_size";
    public static final String MANTA_SKIP_DIRECTORY_DEPTH_KEY = "manta.skip_directory_depth";
    public static final String MANTA_PRUNE_EMPTY_PARENT_DEPTH_KEY = "manta.prune_empty_parent_depth";
    public static final String MANTA_DOWNLOAD_CONTINUATIONS_KEY = "manta.download_continuations";
    public static final String MANTA_METRIC_REPORTER_MODE_KEY = "manta.metric_reporter.mode";
    public static final String MANTA_METRIC_REPORTER_OUTPUT_INTERVAL_KEY = "manta.metric_reporter.output_interval";
    public static final String MANTA_CLIENT_ENCRYPTION_ENABLED_KEY = "manta.client_encryption";
    public static final String MANTA_CONTENT_TYPE_DETECTION_ENABLED_KEY = "manta.content_type_detection";
    public static final String MANTA_ENCRYPTION_KEY_ID_KEY = "manta.encryption_key_id";
    public static final String MANTA_ENCRYPTION_ALGORITHM_KEY = "manta.encryption_algorithm";
    public static final String MANTA_PERMIT_UNENCRYPTED_DOWNLOADS_KEY = "manta.permit_unencrypted_downloads";
    public static final String MANTA_ENCRYPTION_AUTHENTICATION_MODE_KEY = "manta.encryption_auth_mode";
    public static final String MANTA_ENCRYPTION_PRIVATE_KEY_PATH_KEY = "manta.encryption_key_path";
    public static final String MANTA_ENCRYPTION_PRIVATE_KEY_BYTES_KEY = "manta.encryption_key_bytes";
    public static final String MANTA_ENCRYPTION_PRIVATE_KEY_BYTES_BASE64_KEY = "manta.encryption_key_bytes_base64";
    public static final String[] ALL_PROPERTIES = new String[]{"manta.url", "manta.user", "manta.key_id", "manta.key_path", "manta.timeout", "manta.retries", "manta.max_connections", "manta.key_content", "manta.password", "manta.http_buffer_size", "https.protocols", "https.cipherSuites", "manta.tls_insecure", "manta.no_auth", "manta.disable_native_sigs", "manta.tcp_socket_timeout", "manta.verify_uploads", "manta.upload_buffer_size", "manta.connection_request_timeout", "manta.skip_directory_depth", "manta.prune_empty_parent_depth", "manta.download_continuations", "manta.metric_reporter.mode", "manta.metric_reporter.output_interval", "manta.client_encryption", "manta.content_type_detection", "manta.permit_unencrypted_downloads", "manta.encryption_key_id", "manta.encryption_algorithm", "manta.encryption_auth_mode", "manta.encryption_key_path", "manta.encryption_key_bytes", "manta.encryption_key_bytes_base64"};
    private final Map<?, ?> backingMap;

    public MapConfigContext(Map<?, ?> backingMap) {
        this.backingMap = backingMap;
    }

    @Override
    public String getMantaURL() {
        return this.normalizeEmptyAndNullAndDefaultToStringValue(MANTA_URL_KEY, "MANTA_URL");
    }

    @Override
    public String getMantaUser() {
        return this.normalizeEmptyAndNullAndDefaultToStringValue(MANTA_USER_KEY, "MANTA_USER");
    }

    @Override
    public String getMantaKeyId() {
        return this.normalizeEmptyAndNullAndDefaultToStringValue(MANTA_KEY_ID_KEY, "MANTA_KEY_ID");
    }

    @Override
    public String getMantaKeyPath() {
        return this.normalizeEmptyAndNullAndDefaultToStringValue(MANTA_KEY_PATH_KEY, "MANTA_KEY_PATH");
    }

    @Override
    public String getPrivateKeyContent() {
        return this.normalizeEmptyAndNullAndDefaultToStringValue(MANTA_PRIVATE_KEY_CONTENT_KEY, "MANTA_KEY_CONTENT");
    }

    @Override
    public String getPassword() {
        return this.normalizeEmptyAndNullAndDefaultToStringValue(MANTA_PASSWORD_KEY, "MANTA_PASSWORD");
    }

    @Override
    public Integer getTimeout() {
        Integer mapValue = MantaUtils.parseIntegerOrNull(this.backingMap.get(MANTA_TIMEOUT_KEY));
        if (mapValue != null) {
            return mapValue;
        }
        return MantaUtils.parseIntegerOrNull(this.backingMap.get("MANTA_TIMEOUT"));
    }

    @Override
    public Integer getRetries() {
        Integer mapValue = MantaUtils.parseIntegerOrNull(this.backingMap.get(MANTA_RETRIES_KEY));
        if (mapValue != null) {
            return mapValue;
        }
        return MantaUtils.parseIntegerOrNull(this.backingMap.get("MANTA_HTTP_RETRIES"));
    }

    @Override
    public Integer getMaximumConnections() {
        Integer mapValue = MantaUtils.parseIntegerOrNull(this.backingMap.get(MANTA_MAX_CONNS_KEY));
        if (mapValue != null) {
            return mapValue;
        }
        return MantaUtils.parseIntegerOrNull(this.backingMap.get("MANTA_MAX_CONNS"));
    }

    @Override
    public Integer getHttpBufferSize() {
        Integer mapValue = MantaUtils.parseIntegerOrNull(this.backingMap.get(MANTA_HTTP_BUFFER_SIZE_KEY));
        if (mapValue != null) {
            return mapValue;
        }
        return MantaUtils.parseIntegerOrNull(this.backingMap.get("MANTA_HTTP_BUFFER_SIZE"));
    }

    @Override
    public String getHttpsProtocols() {
        return this.normalizeEmptyAndNullAndDefaultToStringValue(MANTA_HTTPS_PROTOCOLS_KEY, "MANTA_HTTPS_PROTOCOLS");
    }

    @Override
    public String getHttpsCipherSuites() {
        return this.normalizeEmptyAndNullAndDefaultToStringValue(MANTA_HTTPS_CIPHERS_KEY, "MANTA_HTTPS_CIPHERS");
    }

    @Override
    public Boolean tlsInsecure() {
        Boolean mapValue = MantaUtils.parseBooleanOrNull(this.backingMap.get(MANTA_TLS_INSECURE_KEY));
        if (mapValue != null) {
            return mapValue;
        }
        return MantaUtils.parseBooleanOrNull(this.backingMap.get(MANTA_TLS_INSECURE_KEY));
    }

    @Override
    public Boolean noAuth() {
        Boolean mapValue = MantaUtils.parseBooleanOrNull(this.backingMap.get(MANTA_NO_AUTH_KEY));
        if (mapValue != null) {
            return mapValue;
        }
        return MantaUtils.parseBooleanOrNull(this.backingMap.get("MANTA_NO_AUTH"));
    }

    @Override
    public Boolean disableNativeSignatures() {
        Boolean mapValue = MantaUtils.parseBooleanOrNull(this.backingMap.get(MANTA_NO_NATIVE_SIGS_KEY));
        if (mapValue != null) {
            return mapValue;
        }
        return MantaUtils.parseBooleanOrNull(this.backingMap.get("MANTA_NO_NATIVE_SIGS"));
    }

    @Override
    public Integer getTcpSocketTimeout() {
        Integer mapValue = MantaUtils.parseIntegerOrNull(this.backingMap.get(MANTA_TCP_SOCKET_TIMEOUT_KEY));
        if (mapValue != null) {
            return mapValue;
        }
        return MantaUtils.parseIntegerOrNull(this.backingMap.get("MANTA_TCP_SOCKET_TIMEOUT"));
    }

    @Override
    public Integer getConnectionRequestTimeout() {
        Integer mapValue = MantaUtils.parseIntegerOrNull(this.backingMap.get(MANTA_CONNECTION_REQUEST_TIMEOUT_KEY));
        if (mapValue != null) {
            return mapValue;
        }
        return MantaUtils.parseIntegerOrNull(this.backingMap.get("MANTA_CONNECTION_REQUEST_TIMEOUT"));
    }

    @Override
    public Integer getExpectContinueTimeout() {
        Integer mapValue = MantaUtils.parseIntegerOrNull(this.backingMap.get(MANTA_EXPECT_CONTINUE_TIMEOUT_KEY));
        if (mapValue != null) {
            return mapValue;
        }
        return MantaUtils.parseIntegerOrNull(this.backingMap.get("MANTA_EXPECT_CONTINUE_TIMEOUT"));
    }

    @Override
    public Boolean verifyUploads() {
        Boolean mapValue = MantaUtils.parseBooleanOrNull(this.backingMap.get(MANTA_VERIFY_UPLOADS_KEY));
        if (mapValue != null) {
            return mapValue;
        }
        return MantaUtils.parseBooleanOrNull(this.backingMap.get("MANTA_VERIFY_UPLOADS"));
    }

    @Override
    public Integer getUploadBufferSize() {
        Integer mapValue = MantaUtils.parseIntegerOrNull(this.backingMap.get(MANTA_UPLOAD_BUFFER_SIZE_KEY));
        if (mapValue != null) {
            return mapValue;
        }
        return MantaUtils.parseIntegerOrNull(this.backingMap.get("MANTA_UPLOAD_BUFFER_SIZE"));
    }

    @Override
    public Integer getSkipDirectoryDepth() {
        Integer mapValue = MantaUtils.parseIntegerOrNull(this.backingMap.get(MANTA_SKIP_DIRECTORY_DEPTH_KEY));
        if (mapValue != null) {
            return mapValue;
        }
        return MantaUtils.parseIntegerOrNull(this.backingMap.get("MANTA_SKIP_DIRECTORY_DEPTH"));
    }

    @Override
    public Integer getPruneEmptyParentDepth() {
        Integer mapValue = MantaUtils.parseIntegerOrNull(this.backingMap.get(MANTA_PRUNE_EMPTY_PARENT_DEPTH_KEY));
        if (mapValue != null) {
            return mapValue;
        }
        return MantaUtils.parseIntegerOrNull(this.backingMap.get("MANTA_PRUNE_EMPTY_PARENT_DEPTH"));
    }

    @Override
    public Integer downloadContinuations() {
        Integer mapValue = MantaUtils.parseIntegerOrNull(this.backingMap.get(MANTA_DOWNLOAD_CONTINUATIONS_KEY));
        if (mapValue != null) {
            return mapValue;
        }
        return MantaUtils.parseIntegerOrNull(this.backingMap.get("MANTA_DOWNLOAD_CONTINUATION"));
    }

    @Override
    public MetricReporterMode getMetricReporterMode() {
        MetricReporterMode metricReporterMode = MantaUtils.parseEnumOrNull(this.backingMap.get(MANTA_METRIC_REPORTER_MODE_KEY), MetricReporterMode.class);
        if (metricReporterMode != null) {
            return metricReporterMode;
        }
        return MantaUtils.parseEnumOrNull(this.backingMap.get("MANTA_METRIC_REPORTER_MODE"), MetricReporterMode.class);
    }

    @Override
    public Integer getMetricReporterOutputInterval() {
        Integer mapValue = MantaUtils.parseIntegerOrNull(this.backingMap.get(MANTA_METRIC_REPORTER_OUTPUT_INTERVAL_KEY));
        if (mapValue != null) {
            return mapValue;
        }
        return MantaUtils.parseIntegerOrNull(this.backingMap.get("MANTA_METRIC_REPORTER_OUTPUT_INTERVAL"));
    }

    @Override
    public Boolean isClientEncryptionEnabled() {
        Boolean enabled = MantaUtils.parseBooleanOrNull(this.backingMap.get(MANTA_CLIENT_ENCRYPTION_ENABLED_KEY));
        if (enabled != null) {
            return enabled;
        }
        return MantaUtils.parseBooleanOrNull(this.backingMap.get("MANTA_CLIENT_ENCRYPTION"));
    }

    @Override
    public Boolean isContentTypeDetectionEnabled() {
        Boolean enabled = MantaUtils.parseBooleanOrNull(this.backingMap.get(MANTA_CONTENT_TYPE_DETECTION_ENABLED_KEY));
        if (enabled != null) {
            return enabled;
        }
        return MantaUtils.parseBooleanOrNull(this.backingMap.get("MANTA_CONTENT_TYPE_DETECTION"));
    }

    @Override
    public String getEncryptionKeyId() {
        return this.normalizeEmptyAndNullAndDefaultToStringValue(MANTA_ENCRYPTION_KEY_ID_KEY, "MANTA_CLIENT_ENCRYPTION_KEY_ID");
    }

    @Override
    public String getEncryptionAlgorithm() {
        return this.normalizeEmptyAndNullAndDefaultToStringValue(MANTA_ENCRYPTION_ALGORITHM_KEY, "MANTA_ENCRYPTION_ALGORITHM");
    }

    @Override
    public Boolean permitUnencryptedDownloads() {
        Boolean permit = MantaUtils.parseBooleanOrNull(this.backingMap.get(MANTA_PERMIT_UNENCRYPTED_DOWNLOADS_KEY));
        if (permit != null) {
            return permit;
        }
        return MantaUtils.parseBooleanOrNull(this.backingMap.get("MANTA_CLIENT_ENCRYPTION"));
    }

    @Override
    public EncryptionAuthenticationMode getEncryptionAuthenticationMode() {
        EncryptionAuthenticationMode authMode = MantaUtils.parseEnumOrNull(this.backingMap.get(MANTA_ENCRYPTION_AUTHENTICATION_MODE_KEY), EncryptionAuthenticationMode.class);
        if (authMode != null) {
            return authMode;
        }
        return MantaUtils.parseEnumOrNull(this.backingMap.get("MANTA_ENCRYPTION_AUTH_MODE"), EncryptionAuthenticationMode.class);
    }

    @Override
    public String getEncryptionPrivateKeyPath() {
        return this.normalizeEmptyAndNullAndDefaultToStringValue(MANTA_ENCRYPTION_PRIVATE_KEY_PATH_KEY, "MANTA_ENCRYPTION_KEY_PATH");
    }

    @Override
    public byte[] getEncryptionPrivateKeyBytes() {
        String base64 = this.normalizeEmptyAndNullAndDefaultToStringValue(MANTA_ENCRYPTION_PRIVATE_KEY_BYTES_BASE64_KEY, "MANTA_ENCRYPTION_KEY_BYTES");
        Object bytesObj = this.backingMap.get(MANTA_ENCRYPTION_PRIVATE_KEY_BYTES_KEY);
        byte[] bytes = bytesObj instanceof byte[] ? (byte[])bytesObj : null;
        if (bytes != null && base64 != null) {
            String msg = "You can't set a base64 private key value AND a byte array value at the same time";
            throw new IllegalArgumentException(msg);
        }
        if (base64 != null) {
            return Base64.getDecoder().decode(base64);
        }
        return bytes;
    }

    Object put(String key, String value) {
        if (key == null) {
            throw new IllegalArgumentException("Config key can't be null");
        }
        if (key.isEmpty()) {
            throw new IllegalArgumentException("Config key can't be blank");
        }
        Map<?, ?> map = this.backingMap;
        return map.put(key, value);
    }

    private String normalizeEmptyAndNullAndDefaultToStringValue(Object ... keys) {
        for (Object k : keys) {
            String value = MantaUtils.toStringEmptyToNull(this.backingMap.get(k));
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public String toString() {
        return ConfigContext.toString(this);
    }

    static {
        Arrays.sort(ALL_PROPERTIES);
    }
}

