/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dav.microsoft;

import ch.cyberduck.core.date.RFC1123DateFormatter;
import ch.cyberduck.core.dav.DAVSession;
import ch.cyberduck.core.dav.DAVTimestampFeature;
import com.github.sardine.DavResource;
import com.github.sardine.util.SardineUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;

public class MicrosoftIISDAVTimestampFeature
extends DAVTimestampFeature {
    private static final String MS_NAMESPACE_URI = "urn:schemas-microsoft-com:";
    private static final String MS_NAMESPACE_PREFIX = "Z";
    private static final String MS_NAMESPACE_LASTMODIFIED = "Win32LastModifiedTime";
    public static final QName LAST_MODIFIED_WIN32_CUSTOM_NAMESPACE = new QName("urn:schemas-microsoft-com:", "Win32LastModifiedTime", "Z");

    public MicrosoftIISDAVTimestampFeature(DAVSession session) {
        super(session);
    }

    @Override
    protected List<Element> getCustomProperties(DavResource resource, Long modified) {
        ArrayList<Element> props = new ArrayList<Element>();
        Element element = SardineUtil.createElement((QName)LAST_MODIFIED_WIN32_CUSTOM_NAMESPACE);
        element.setTextContent(new RFC1123DateFormatter().format(modified.longValue(), TimeZone.getTimeZone("GMT")));
        props.add(element);
        return props;
    }
}

