/*
 * Decompiled with CFR 0.152.
 */
package com.nulabinc.zxcvbn.matchers;

import java.io.InputStream;

class ResourceLoader {
    ResourceLoader() {
    }

    InputStream getInputStream(String path) {
        InputStream in = this.getResourceAsStreamWithFallback(path);
        if (in == null) {
            throw new IllegalStateException("Could not get resource as stream");
        }
        return in;
    }

    public InputStream getResourceAsStreamWithFallback(String path) {
        InputStream in;
        ClassLoader cl2;
        try {
            cl2 = Thread.currentThread().getContextClassLoader();
            in = this.getResourceAsStream(cl2, path);
            if (in != null) {
                return in;
            }
        }
        catch (Throwable cl2) {
            // empty catch block
        }
        try {
            cl2 = this.getClass().getClassLoader();
            in = this.getResourceAsStream(cl2, path);
            if (in != null) {
                return in;
            }
        }
        catch (Throwable cl3) {
            // empty catch block
        }
        try {
            cl2 = ClassLoader.getSystemClassLoader();
            in = this.getResourceAsStream(cl2, path);
            if (in != null) {
                return in;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private InputStream getResourceAsStream(ClassLoader cl, String path) {
        try {
            InputStream in;
            if (cl != null && (in = cl.getResourceAsStream(path)) != null) {
                return in;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }
}

