/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sftp;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.exception.ChecksumException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.sftp.AbstractHostKeyCallback;
import java.security.Key;
import java.security.PublicKey;
import net.schmizz.sshj.common.KeyType;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.bouncycastle.util.encoders.Base64;

public abstract class PreferencesHostKeyVerifier
extends AbstractHostKeyCallback {
    private static final Logger log = Logger.getLogger(PreferencesHostKeyVerifier.class);
    private final Preferences preferences = PreferencesFactory.get();

    public boolean verify(Host host, PublicKey key) throws ConnectionCanceledException, ChecksumException {
        String lookup = this.preferences.getProperty(this.toFormat(host, key));
        if (StringUtils.isEmpty((CharSequence)lookup)) {
            lookup = this.preferences.getProperty(this.toFormat(host, key, false));
        }
        if (StringUtils.equals((CharSequence)Base64.toBase64String((byte[])key.getEncoded()), (CharSequence)lookup)) {
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Accepted host key %s matching %s", key, lookup));
            }
            return true;
        }
        boolean accept = null == lookup ? this.isUnknownKeyAccepted(host, key) : this.isChangedKeyAccepted(host, key);
        return accept;
    }

    private String toFormat(Host host, PublicKey key) {
        return this.toFormat(host, key, true);
    }

    private String toFormat(Host host, PublicKey key, boolean port) {
        if (port) {
            return String.format("ssh.hostkey.%s.%s:%d", KeyType.fromKey((Key)key), host.getHostname(), host.getPort());
        }
        return String.format("ssh.hostkey.%s.%s", KeyType.fromKey((Key)key), host.getHostname());
    }

    @Override
    protected void allow(Host host, PublicKey key, boolean persist) {
        if (persist) {
            this.preferences.setProperty(this.toFormat(host, key), Base64.toBase64String((byte[])key.getEncoded()));
        }
    }
}

