/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.pub.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.irods.jargon.core.exception.JargonRuntimeException;
import org.irods.jargon.core.pub.io.IRODSFileInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackingIrodsInputStream
extends InputStream {
    private final IRODSFileInputStream irodsFileInputStream;
    private ByteArrayInputStream byteArrayInputStream = null;
    private final int bufferSizeForIrods;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private boolean done = false;

    public PackingIrodsInputStream(IRODSFileInputStream irodsFileInputStream) {
        if (irodsFileInputStream == null) {
            throw new IllegalArgumentException("null irodsFileInputStream");
        }
        this.irodsFileInputStream = irodsFileInputStream;
        this.bufferSizeForIrods = irodsFileInputStream.getFileIOOperations().getJargonProperties().getGetBufferSize();
        this.log.info("buffer size for gets from iRODS:{}", (Object)this.bufferSizeForIrods);
        if (this.bufferSizeForIrods <= 0) {
            throw new JargonRuntimeException("misconfiguration in jargon.properties, getBufferSize is <= 0");
        }
    }

    private void checkAndInitializeNextByteInputStream() throws IOException {
        this.log.debug("checkAndInitializeNextByteInputStream()");
        if (this.done) {
            return;
        }
        if (this.byteArrayInputStream == null) {
            this.log.debug("Getting next buffer from iRODS...");
            this.fillByteBufferFromIrods();
        }
    }

    private void fillByteBufferFromIrods() throws IOException {
        byte[] b = new byte[this.bufferSizeForIrods];
        int length = this.irodsFileInputStream.read(b);
        if (length == -1) {
            this.byteArrayInputStream = null;
            this.done = true;
        } else {
            this.byteArrayInputStream = new ByteArrayInputStream(b, 0, length);
        }
    }

    @Override
    public int read() throws IOException {
        byte[] buffer = new byte[1];
        int temp = this.read(buffer, 0, 1);
        if (temp < 0) {
            return -1;
        }
        return buffer[0] & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.log.debug("read()");
        this.checkAndInitializeNextByteInputStream();
        if (this.byteArrayInputStream == null) {
            this.log.info("at end of stream");
            return -1;
        }
        int myOffset = off;
        int myLen = len;
        int readFromCurrent = 0;
        int lenToRead = 0;
        int totalRead = 0;
        while (myLen > 0) {
            this.log.debug("looping to fill buffer while length remaining is:{}", (Object)myLen);
            if (this.byteArrayInputStream.available() > 0) {
                this.log.debug("have available, copy into output array");
                lenToRead = Math.min(myLen, this.byteArrayInputStream.available());
                readFromCurrent = this.byteArrayInputStream.read(b, myOffset, lenToRead);
                myLen -= lenToRead;
                totalRead += readFromCurrent;
                myOffset += readFromCurrent;
                this.log.debug("read a total of:{} from current buffer", (Object)readFromCurrent);
                continue;
            }
            this.log.debug("read all of current stream, get next buffer from iRODS...");
            this.fillByteBufferFromIrods();
            if (this.byteArrayInputStream != null) continue;
            this.log.debug("end of iRODS data");
            break;
        }
        this.log.debug("len for this read:{}", (Object)totalRead);
        return totalRead > 0 ? totalRead : -1;
    }

    @Override
    public long skip(long n) throws IOException {
        long mySkip = n;
        long skipped = 0L;
        this.checkAndInitializeNextByteInputStream();
        if (this.byteArrayInputStream.available() > 0) {
            long toSkip = Math.min(n, (long)this.byteArrayInputStream.available());
            this.log.debug("skipping in byte buffer:{}", (Object)toSkip);
            mySkip -= toSkip;
            this.byteArrayInputStream.skip(toSkip);
            skipped += toSkip;
        }
        if (this.byteArrayInputStream.available() == 0) {
            this.byteArrayInputStream = null;
        }
        if (mySkip > 0L) {
            skipped += this.irodsFileInputStream.skip(mySkip);
        }
        return skipped;
    }

    @Override
    public int available() throws IOException {
        return this.irodsFileInputStream.available();
    }

    @Override
    public void close() throws IOException {
        this.irodsFileInputStream.close();
    }

    @Override
    public synchronized void reset() throws IOException {
        this.irodsFileInputStream.reset();
    }

    @Override
    public boolean markSupported() {
        return this.irodsFileInputStream.markSupported();
    }
}

