/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.query;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.irods.jargon.core.exception.JargonException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExtensibleMetaDataMapping {
    private static Logger log = LoggerFactory.getLogger(ExtensibleMetaDataMapping.class);
    private Map<String, String> extensibleMappings = new HashMap<String, String>();

    public static synchronized ExtensibleMetaDataMapping instance(Map<String, String> extensibleMappings) throws JargonException {
        log.debug("cacheing and returning fresh extensibleMetaDataMapping");
        HashMap<String, String> copiedExtensibleMappings = new HashMap<String, String>(extensibleMappings);
        return new ExtensibleMetaDataMapping(Collections.unmodifiableMap(copiedExtensibleMappings));
    }

    private ExtensibleMetaDataMapping(Map<String, String> extensibleMappings) throws JargonException {
        if (extensibleMappings == null || extensibleMappings.size() == 0) {
            throw new JargonException("null or empty extensible mappings");
        }
        this.extensibleMappings = extensibleMappings;
    }

    public String getIndexFromColumnName(String columnName) {
        String index = this.extensibleMappings.get(columnName);
        return index;
    }

    public String getColumnNameFromIndex(String index) {
        String columnName = null;
        String foundIntValue = "";
        for (String key : this.extensibleMappings.keySet()) {
            foundIntValue = this.extensibleMappings.get(key);
            if (!foundIntValue.equals(index)) continue;
            columnName = key;
            break;
        }
        return columnName;
    }
}

