/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptolib.v1;

import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;
import org.cryptomator.cryptolib.api.Cryptor;
import org.cryptomator.cryptolib.api.KeyFile;
import org.cryptomator.cryptolib.common.AesKeyWrap;
import org.cryptomator.cryptolib.common.MacSupplier;
import org.cryptomator.cryptolib.common.Scrypt;
import org.cryptomator.cryptolib.v1.FileContentCryptorImpl;
import org.cryptomator.cryptolib.v1.FileHeaderCryptorImpl;
import org.cryptomator.cryptolib.v1.FileNameCryptorImpl;
import org.cryptomator.cryptolib.v1.KeyFileImpl;

class CryptorImpl
implements Cryptor {
    private final SecretKey encKey;
    private final SecretKey macKey;
    private final SecureRandom random;
    private final FileContentCryptorImpl fileContentCryptor;
    private final FileHeaderCryptorImpl fileHeaderCryptor;
    private final FileNameCryptorImpl fileNameCryptor;

    CryptorImpl(SecretKey encKey, SecretKey macKey, SecureRandom random) {
        this.encKey = encKey;
        this.macKey = macKey;
        this.random = random;
        this.fileHeaderCryptor = new FileHeaderCryptorImpl(encKey, macKey, random);
        this.fileContentCryptor = new FileContentCryptorImpl(macKey, random);
        this.fileNameCryptor = new FileNameCryptorImpl(encKey, macKey);
    }

    @Override
    public FileContentCryptorImpl fileContentCryptor() {
        this.assertNotDestroyed();
        return this.fileContentCryptor;
    }

    @Override
    public FileHeaderCryptorImpl fileHeaderCryptor() {
        this.assertNotDestroyed();
        return this.fileHeaderCryptor;
    }

    @Override
    public FileNameCryptorImpl fileNameCryptor() {
        this.assertNotDestroyed();
        return this.fileNameCryptor;
    }

    @Override
    public boolean isDestroyed() {
        if (this.encKey instanceof Destroyable && this.macKey instanceof Destroyable) {
            return this.encKey.isDestroyed() || this.macKey.isDestroyed();
        }
        return false;
    }

    @Override
    public void close() {
        this.destroy();
    }

    @Override
    public void destroy() {
        this.destroyQuietly(this.encKey);
        this.destroyQuietly(this.macKey);
    }

    @Override
    public KeyFile writeKeysToMasterkeyFile(CharSequence passphrase, int vaultVersion) {
        return this.writeKeysToMasterkeyFile(passphrase, new byte[0], vaultVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyFile writeKeysToMasterkeyFile(CharSequence passphrase, byte[] pepper, int vaultVersion) {
        byte[] wrappedMacKey;
        byte[] wrappedEncryptionKey;
        this.assertNotDestroyed();
        byte[] salt = new byte[8];
        this.random.nextBytes(salt);
        byte[] saltAndPepper = new byte[salt.length + pepper.length];
        System.arraycopy(salt, 0, saltAndPepper, 0, salt.length);
        System.arraycopy(pepper, 0, saltAndPepper, salt.length, pepper.length);
        byte[] kekBytes = Scrypt.scrypt(passphrase, saltAndPepper, 32768, 8, 32);
        try {
            SecretKeySpec kek = new SecretKeySpec(kekBytes, "AES");
            wrappedEncryptionKey = AesKeyWrap.wrap(kek, this.encKey);
            wrappedMacKey = AesKeyWrap.wrap(kek, this.macKey);
        }
        finally {
            Arrays.fill(kekBytes, (byte)0);
        }
        Mac mac = MacSupplier.HMAC_SHA256.withKey(this.macKey);
        byte[] versionMac = mac.doFinal(ByteBuffer.allocate(4).putInt(vaultVersion).array());
        KeyFileImpl keyfile = new KeyFileImpl();
        keyfile.setVersion(vaultVersion);
        keyfile.scryptSalt = salt;
        keyfile.scryptCostParam = 32768;
        keyfile.scryptBlockSize = 8;
        keyfile.encryptionMasterKey = wrappedEncryptionKey;
        keyfile.macMasterKey = wrappedMacKey;
        keyfile.versionMac = versionMac;
        return keyfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getRawKey() {
        byte[] rawEncKey = this.encKey.getEncoded();
        byte[] rawMacKeyKey = this.macKey.getEncoded();
        try {
            byte[] rawKey = new byte[rawEncKey.length + rawMacKeyKey.length];
            System.arraycopy(rawEncKey, 0, rawKey, 0, rawEncKey.length);
            System.arraycopy(rawMacKeyKey, 0, rawKey, rawEncKey.length, rawMacKeyKey.length);
            byte[] byArray = rawKey;
            return byArray;
        }
        finally {
            Arrays.fill(rawEncKey, (byte)0);
            Arrays.fill(rawMacKeyKey, (byte)0);
        }
    }

    private void destroyQuietly(SecretKey key) {
        try {
            if (key instanceof Destroyable && !key.isDestroyed()) {
                key.destroy();
            }
        }
        catch (DestroyFailedException destroyFailedException) {
            // empty catch block
        }
    }

    private void assertNotDestroyed() {
        if (this.isDestroyed()) {
            throw new IllegalStateException("Cryptor destroyed.");
        }
    }
}

