/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.cli;

import ch.cyberduck.cli.Console;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.DisabledProgressListener;
import ch.cyberduck.core.IndexedListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.UserDateFormatterFactory;
import ch.cyberduck.core.date.AbstractUserDateFormatter;
import org.apache.commons.lang3.StringUtils;
import org.fusesource.jansi.Ansi;

public class TerminalListProgressListener
extends IndexedListProgressListener {
    private final Console console = new Console();
    private final AbstractUserDateFormatter formatter = UserDateFormatterFactory.get();
    private final boolean verbose;
    private final ProgressListener listener;

    public TerminalListProgressListener() {
        this(false);
    }

    public TerminalListProgressListener(boolean verbose) {
        this(verbose, new DisabledProgressListener());
    }

    public TerminalListProgressListener(boolean verbose, ProgressListener listener) {
        this.verbose = verbose;
        this.listener = listener;
    }

    @Override
    public void visit(AttributedList<Path> list, int index, Path file) {
        if (this.verbose) {
            if (file.isSymbolicLink()) {
                this.console.printf("%n%sl%s\t%s\t%s -> %s%s", Ansi.ansi().bold(), file.attributes().getPermission().getSymbol(), this.formatter.getMediumFormat(file.attributes().getModificationDate()), file.getName(), file.getSymlinkTarget().getAbsolute(), Ansi.ansi().reset());
            } else {
                this.console.printf("%n%s%s%s\t%s\t%s\t%s%s", Ansi.ansi().bold(), file.isDirectory() ? "d" : "-", file.attributes().getPermission().getSymbol(), this.formatter.getMediumFormat(file.attributes().getModificationDate()), StringUtils.isNotBlank((CharSequence)file.attributes().getRegion()) ? file.attributes().getRegion() : "", file.getName(), Ansi.ansi().reset());
            }
        } else {
            this.console.printf("%n%s%s%s", Ansi.ansi().bold(), file.getName(), Ansi.ansi().reset());
        }
    }

    @Override
    public void message(String message) {
        this.listener.message(message);
    }
}

