/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.exceptions;

import java.io.IOException;

public class ContentLengthNotMatchException
extends IOException {
    private final String fileName;
    private final long contentLength;
    private final long totalBytes;

    public ContentLengthNotMatchException(String fileName, long contentLength, long totalBytes) {
        super(String.format("The Content length for %s (%d) does not match the number of bytes read (%d)", fileName, contentLength, totalBytes));
        this.fileName = fileName;
        this.contentLength = contentLength;
        this.totalBytes = totalBytes;
    }

    public String getFileName() {
        return this.fileName;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }
}

