/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive.features;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.onedrive.GraphExceptionMappingService;
import ch.cyberduck.core.onedrive.GraphSession;
import ch.cyberduck.core.onedrive.features.GraphAttributesFinderFeature;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import org.nuxeo.onedrive.client.Files;
import org.nuxeo.onedrive.client.OneDriveAPIException;
import org.nuxeo.onedrive.client.types.DriveItem;

public class GraphDirectoryFeature
implements Directory<Void> {
    private final GraphSession session;

    public GraphDirectoryFeature(GraphSession session) {
        this.session = session;
    }

    public Path mkdir(Path directory, String region, TransferStatus status) throws BackgroundException {
        DriveItem folder = this.session.toFolder(directory.getParent());
        try {
            DriveItem.Metadata metadata = Files.createFolder((DriveItem)folder, (String)directory.getName());
            return new Path(directory.getParent(), directory.getName(), directory.getType(), new GraphAttributesFinderFeature(this.session).toAttributes(metadata));
        }
        catch (OneDriveAPIException e) {
            throw new GraphExceptionMappingService().map("Cannot create folder {0}", e, directory);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Cannot create folder {0}", (Throwable)e, directory);
        }
    }

    public boolean isSupported(Path workdir, String name) {
        return this.session.isAccessible(workdir);
    }

    public Directory<Void> withWriter(Write writer) {
        return this;
    }
}

