/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.brick;

import ch.cyberduck.core.BookmarkCollection;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.DisabledConnectionCallback;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostPasswordStore;
import ch.cyberduck.core.PasswordStoreFactory;
import ch.cyberduck.core.brick.BrickSession;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.http.DisabledServiceUnavailableRetryStrategy;
import ch.cyberduck.core.threading.BackgroundAction;
import ch.cyberduck.core.threading.BackgroundActionRegistry;
import ch.cyberduck.core.threading.BackgroundActionState;
import ch.cyberduck.core.threading.BackgroundActionStateCancelCallback;
import ch.cyberduck.core.threading.CancelCallback;
import org.apache.http.HttpResponse;
import org.apache.http.protocol.HttpContext;
import org.apache.log4j.Logger;

public class BrickUnauthorizedRetryStrategy
extends DisabledServiceUnavailableRetryStrategy {
    private static final Logger log = Logger.getLogger(BrickUnauthorizedRetryStrategy.class);
    private static final int MAX_RETRIES = 1;
    private final HostPasswordStore store = PasswordStoreFactory.get();
    private final BrickSession session;
    private final CancelCallback cancel;

    public BrickUnauthorizedRetryStrategy(BrickSession session, CancelCallback cancel) {
        this.session = session;
        this.cancel = cancel;
    }

    public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
        switch (response.getStatusLine().getStatusCode()) {
            case 401: {
                if (executionCount > 1) break;
                try {
                    BookmarkCollection bookmarks;
                    Host bookmark = this.session.getHost();
                    Credentials credentials = bookmark.getCredentials();
                    credentials.reset();
                    this.session.pair(bookmark, (ConnectionCallback)new DisabledConnectionCallback(), new BackgroundActionRegistryCancelCallback(this.cancel));
                    if (credentials.isSaved()) {
                        this.store.save(bookmark);
                    }
                    if ((bookmarks = BookmarkCollection.defaultCollection()).isLoaded() && bookmarks.contains((Object)bookmark)) {
                        bookmarks.collectionItemChanged((Object)bookmark);
                    }
                    credentials.reset();
                    return true;
                }
                catch (BackgroundException e) {
                    log.warn((Object)String.format("Failure %s trying to refresh pairing after error response %s", new Object[]{e, response}));
                }
            }
        }
        return false;
    }

    private static final class BackgroundActionRegistryCancelCallback
    implements CancelCallback {
        private final CancelCallback delegate;

        public BackgroundActionRegistryCancelCallback(CancelCallback delegate) {
            this.delegate = delegate;
        }

        public void verify() throws ConnectionCanceledException {
            this.delegate.verify();
            for (BackgroundAction action : BackgroundActionRegistry.global()) {
                if (null == action) continue;
                new BackgroundActionStateCancelCallback((BackgroundActionState)action).verify();
            }
        }
    }
}

