/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.http.signature;

import com.joyent.http.signature.KeyLoadException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyPair;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;

public final class KeyPairLoader {
    public static final String PROVIDER_PKCS11_NSS = "SunPKCS11-NSS";
    public static final String PROVIDER_BOUNCY_CASTLE = "BC";
    private static final JcaPEMKeyConverter CONVERTER_PKCS11_NSS;
    private static final JcaPEMKeyConverter CONVERTER_BOUNCY_CASTLE;

    private KeyPairLoader() {
    }

    public static KeyPair getKeyPair(File keyFile) throws IOException {
        return KeyPairLoader.getKeyPair(keyFile.toPath(), null);
    }

    public static KeyPair getKeyPair(File keyFile, char[] password) throws IOException {
        return KeyPairLoader.getKeyPair(keyFile.toPath(), password);
    }

    public static KeyPair getKeyPair(Path keyPath) throws IOException {
        return KeyPairLoader.getKeyPair(keyPath, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static KeyPair getKeyPair(Path keyPath, char[] password) throws IOException {
        if (keyPath == null) {
            throw new FileNotFoundException("No key file path specified");
        }
        if (!Files.exists(keyPath, new LinkOption[0])) {
            throw new FileNotFoundException(String.format("No key file available at path: %s", keyPath));
        }
        if (!Files.isReadable(keyPath)) {
            throw new IOException(String.format("Can't read key file from path: %s", keyPath));
        }
        try (InputStream is = Files.newInputStream(keyPath, new OpenOption[0]);){
            KeyPair keyPair = KeyPairLoader.getKeyPair(is, password);
            return keyPair;
        }
        catch (KeyLoadException kle) {
            throw new IOException("Unable to load private key at path: " + keyPath, kle);
        }
    }

    public static KeyPair getKeyPair(String privateKeyContent, char[] password) throws IOException {
        byte[] pKeyBytes = privateKeyContent.getBytes(StandardCharsets.US_ASCII);
        return KeyPairLoader.getKeyPair(pKeyBytes, password);
    }

    public static KeyPair getKeyPair(byte[] pKeyBytes, char[] password) throws IOException {
        if (pKeyBytes == null) {
            throw new IllegalArgumentException("pKeyBytes must be present");
        }
        try (ByteArrayInputStream is = new ByteArrayInputStream(pKeyBytes);){
            KeyPair keyPair = KeyPairLoader.getKeyPair(is, password);
            return keyPair;
        }
    }

    public static KeyPair getKeyPair(InputStream is, char[] password) throws IOException {
        return KeyPairLoader.getKeyPair(is, password, null);
    }

    public static KeyPair getKeyPair(InputStream is, char[] password, DesiredSecurityProvider provider) throws IOException {
        boolean attemptPKCS11NSS;
        PEMKeyPair pemKeyPair;
        Object pemObject;
        try (InputStreamReader isr = new InputStreamReader(is, StandardCharsets.US_ASCII);
             BufferedReader br = new BufferedReader(isr);
             PEMParser pemParser = new PEMParser((Reader)br);){
            pemObject = pemParser.readObject();
        }
        if (pemObject instanceof PEMEncryptedKeyPair) {
            if (password == null) {
                throw new KeyLoadException("Loaded key is encrypted but no password was supplied.");
            }
            PEMDecryptorProvider decryptorProvider = new JcePEMDecryptorProviderBuilder().build(password);
            PEMEncryptedKeyPair encryptedPemObject = (PEMEncryptedKeyPair)pemObject;
            pemKeyPair = encryptedPemObject.decryptKeyPair(decryptorProvider);
        } else if (pemObject instanceof PEMKeyPair) {
            if (password != null) {
                throw new KeyLoadException("Loaded key is not encrypted but a password was supplied.");
            }
            pemKeyPair = (PEMKeyPair)pemObject;
        } else {
            if (pemObject == null) {
                throw new KeyLoadException("Failed to load PEM object, please verify the input is a private key");
            }
            throw new KeyLoadException("Unexpected PEM object loaded: " + pemObject.getClass().getCanonicalName());
        }
        if (provider != null && provider.equals((Object)DesiredSecurityProvider.NSS) && CONVERTER_PKCS11_NSS == null) {
            throw new KeyLoadException("SunPKCS11-NSS provider requested but unavailable. Is java.security configured correctly?");
        }
        boolean bl = attemptPKCS11NSS = provider == null || provider.equals((Object)DesiredSecurityProvider.NSS);
        if (CONVERTER_PKCS11_NSS != null && attemptPKCS11NSS) {
            return CONVERTER_PKCS11_NSS.getKeyPair(pemKeyPair);
        }
        return CONVERTER_BOUNCY_CASTLE.getKeyPair(pemKeyPair);
    }

    static {
        Provider providerPkcs11NSS = Security.getProvider(PROVIDER_PKCS11_NSS);
        CONVERTER_PKCS11_NSS = providerPkcs11NSS != null ? new JcaPEMKeyConverter().setProvider(PROVIDER_PKCS11_NSS) : null;
        Provider providerBouncyCastle = Security.getProvider(PROVIDER_BOUNCY_CASTLE);
        if (providerBouncyCastle == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        CONVERTER_BOUNCY_CASTLE = new JcaPEMKeyConverter().setProvider(PROVIDER_BOUNCY_CASTLE);
    }

    public static enum DesiredSecurityProvider {
        BC("BC"),
        NSS("SunPKCS11-NSS");

        private final String providerCode;

        private DesiredSecurityProvider(String providerCode) {
            this.providerCode = providerCode;
        }

        public String toString() {
            return this.providerCode;
        }
    }
}

