/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.ftp;

import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Command;
import ch.cyberduck.core.ftp.FTPClient;
import ch.cyberduck.core.ftp.FTPExceptionMappingService;
import ch.cyberduck.core.ftp.FTPSession;
import ch.cyberduck.core.ftp.LoggingProtocolCommandListener;
import java.io.IOException;
import org.apache.log4j.Logger;

public class FTPCommandFeature
implements Command {
    private static final Logger log = Logger.getLogger(FTPCommandFeature.class);
    private final FTPSession session;

    public FTPCommandFeature(FTPSession session) {
        this.session = session;
    }

    public void send(String command, ProgressListener progress, TranscriptListener transcript) throws BackgroundException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Send command %s", command));
        }
        progress.message(command);
        LoggingProtocolCommandListener listener = new LoggingProtocolCommandListener(transcript);
        try {
            ((FTPClient)((Object)this.session.getClient())).addProtocolCommandListener(listener);
            ((FTPClient)((Object)this.session.getClient())).sendSiteCommand(command);
        }
        catch (IOException e) {
            throw new FTPExceptionMappingService().map(e);
        }
        finally {
            ((FTPClient)((Object)this.session.getClient())).removeProtocolCommandListener(listener);
        }
    }
}

