/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.onedrive.client;

import com.eclipsesource.json.JsonObject;
import java.io.IOException;
import java.net.URL;
import java.util.Set;
import org.nuxeo.onedrive.client.OneDriveAPI;
import org.nuxeo.onedrive.client.OneDriveJsonObject;
import org.nuxeo.onedrive.client.OneDriveJsonRequest;
import org.nuxeo.onedrive.client.OneDriveJsonResponse;
import org.nuxeo.onedrive.client.RequestExecutor;
import org.nuxeo.onedrive.client.RequestHeader;

public class OneDriveLongRunningAction {
    private final URL monitorUrl;
    private final OneDriveAPI oneDriveAPI;

    public OneDriveLongRunningAction(URL monitorUrl, OneDriveAPI oneDriveAPI) {
        this.monitorUrl = monitorUrl;
        this.oneDriveAPI = oneDriveAPI;
    }

    public void await(ProgressCallback progressCallback) throws IOException {
        boolean finished = false;
        int timeout = 8;
        while (!finished) {
            try {
                Thread.sleep(1 << timeout);
            }
            catch (InterruptedException e) {
                return;
            }
            StatusObject statusObject = this.getStatus();
            if (statusObject.status == Status.completed) {
                finished = true;
            }
            if (null != progressCallback) {
                progressCallback.post(statusObject);
            }
            timeout = Math.min(timeout + 1, 13);
        }
    }

    public StatusObject getStatus() throws IOException {
        OneDriveJsonResponse jsonRequest = new OneDriveJsonRequest(this.monitorUrl, "GET"){

            @Override
            protected void addAuthorizationHeader(RequestExecutor executor, Set<RequestHeader> headers) {
            }
        }.sendRequest(this.oneDriveAPI.getExecutor());
        return new StatusObject(jsonRequest.getContent());
    }

    public static interface ProgressCallback {
        public void post(StatusObject var1);
    }

    public class StatusObject
    extends OneDriveJsonObject {
        private String operation;
        private float percentage;
        private Status status;

        public StatusObject(JsonObject json) {
            super(json);
        }

        @Override
        protected void parseMember(JsonObject.Member member) {
            if ("operation".equals(member.getName())) {
                this.operation = member.getValue().asString();
            } else if ("percentageComplete".equals(member.getName())) {
                this.percentage = member.getValue().asFloat();
            } else if ("status".equals(member.getName())) {
                this.status = Status.valueOf(member.getValue().asString());
            }
            super.parseMember(member);
        }

        public Status getStatus() {
            return this.status;
        }

        public float getPercentage() {
            return this.percentage;
        }

        public String getOperation() {
            return this.operation;
        }
    }

    public static enum Status {
        notStarted,
        inProgress,
        completed,
        updating,
        failed,
        deletePending,
        deleteFailed,
        waiting;

    }
}

