/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.onedrive.client;

import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import com.eclipsesource.json.ParseException;
import java.util.Objects;
import org.nuxeo.onedrive.client.OneDriveAPI;
import org.nuxeo.onedrive.client.OneDriveAPIException;
import org.nuxeo.onedrive.client.OneDriveResource;
import org.nuxeo.onedrive.client.OneDriveRuntimeException;
import org.nuxeo.onedrive.client.OneDriveThumbnail;
import org.nuxeo.onedrive.client.OneDriveThumbnailSize;

public class OneDriveThumbnailSet
extends OneDriveResource {
    private final String itemId;
    private final int thumbId;

    OneDriveThumbnailSet(OneDriveAPI api, int thumbId) {
        super(api, "root$$" + thumbId);
        this.itemId = null;
        this.thumbId = thumbId;
    }

    OneDriveThumbnailSet(OneDriveAPI api, String itemId, int thumbId) {
        super(api, itemId + "$$" + thumbId);
        this.itemId = Objects.requireNonNull(itemId);
        this.thumbId = thumbId;
    }

    @Override
    public boolean isRoot() {
        return this.itemId == null;
    }

    public class Metadata
    extends OneDriveResource.Metadata {
        private OneDriveThumbnail.Metadata small;
        private OneDriveThumbnail.Metadata medium;
        private OneDriveThumbnail.Metadata large;
        private OneDriveThumbnail.Metadata source;

        public Metadata(JsonObject json) {
            super(json);
        }

        public String getItemId() {
            return OneDriveThumbnailSet.this.itemId;
        }

        public int getThumbId() {
            return OneDriveThumbnailSet.this.thumbId;
        }

        public OneDriveThumbnail.Metadata getSmall() {
            return this.small;
        }

        public OneDriveThumbnail.Metadata getMedium() {
            return this.medium;
        }

        public OneDriveThumbnail.Metadata getLarge() {
            return this.large;
        }

        public OneDriveThumbnail.Metadata getSource() {
            return this.source;
        }

        @Override
        protected void parseMember(JsonObject.Member member) {
            super.parseMember(member);
            try {
                JsonValue value = member.getValue();
                String memberName = member.getName();
                if ("small".equals(memberName)) {
                    OneDriveThumbnail thumbnail;
                    OneDriveThumbnail oneDriveThumbnail = thumbnail = this.initThumbnail(OneDriveThumbnailSize.SMALL);
                    Objects.requireNonNull(oneDriveThumbnail);
                    this.small = new OneDriveThumbnail.Metadata(oneDriveThumbnail, value.asObject());
                } else if ("medium".equals(memberName)) {
                    OneDriveThumbnail thumbnail;
                    OneDriveThumbnail oneDriveThumbnail = thumbnail = this.initThumbnail(OneDriveThumbnailSize.MEDIUM);
                    Objects.requireNonNull(oneDriveThumbnail);
                    this.medium = new OneDriveThumbnail.Metadata(oneDriveThumbnail, value.asObject());
                } else if ("large".equals(memberName)) {
                    OneDriveThumbnail thumbnail;
                    OneDriveThumbnail oneDriveThumbnail = thumbnail = this.initThumbnail(OneDriveThumbnailSize.LARGE);
                    Objects.requireNonNull(oneDriveThumbnail);
                    this.large = new OneDriveThumbnail.Metadata(oneDriveThumbnail, value.asObject());
                } else if ("source".equals(memberName)) {
                    OneDriveThumbnail thumbnail;
                    OneDriveThumbnail oneDriveThumbnail = thumbnail = this.initThumbnail(OneDriveThumbnailSize.SOURCE);
                    Objects.requireNonNull(oneDriveThumbnail);
                    this.source = new OneDriveThumbnail.Metadata(oneDriveThumbnail, value.asObject());
                }
            }
            catch (ParseException e) {
                throw new OneDriveRuntimeException(new OneDriveAPIException(e.getMessage(), e));
            }
        }

        private OneDriveThumbnail initThumbnail(OneDriveThumbnailSize size) {
            if (OneDriveThumbnailSet.this.itemId == null) {
                return new OneDriveThumbnail(OneDriveThumbnailSet.this.getApi(), OneDriveThumbnailSet.this.thumbId, size);
            }
            return new OneDriveThumbnail(OneDriveThumbnailSet.this.getApi(), OneDriveThumbnailSet.this.itemId, OneDriveThumbnailSet.this.thumbId, size);
        }

        @Override
        public OneDriveResource getResource() {
            return OneDriveThumbnailSet.this;
        }
    }
}

