/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googlestorage;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathNormalizer;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.googlestorage.GoogleStorageAttributesFinderFeature;
import ch.cyberduck.core.googlestorage.GoogleStorageExceptionMappingService;
import ch.cyberduck.core.googlestorage.GoogleStorageSession;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import com.google.api.services.storage.Storage;
import com.google.api.services.storage.model.Bucket;
import com.google.api.services.storage.model.Buckets;
import java.io.IOException;
import java.util.EnumSet;

public class GoogleStorageBucketListService
implements ListService {
    private final Preferences preferences = PreferencesFactory.get();
    private final GoogleStorageSession session;
    private GoogleStorageAttributesFinderFeature attributes;

    public GoogleStorageBucketListService(GoogleStorageSession session) {
        this.session = session;
        this.attributes = new GoogleStorageAttributesFinderFeature(session);
    }

    public AttributedList<Path> list(Path directory, ListProgressListener listener) throws BackgroundException {
        try {
            Buckets response;
            AttributedList buckets = new AttributedList();
            String page = null;
            do {
                if (null == (response = (Buckets)((Storage)this.session.getClient()).buckets().list(this.session.getHost().getCredentials().getUsername()).setMaxResults(Long.valueOf(this.preferences.getLong("googlestorage.listing.chunksize"))).setPageToken(page).execute()).getItems()) continue;
                for (Bucket item : response.getItems()) {
                    Path bucket = new Path(PathNormalizer.normalize((String)item.getName()), EnumSet.of(AbstractPath.Type.volume, AbstractPath.Type.directory), this.attributes.toAttributes(item));
                    buckets.add((Referenceable)bucket);
                    listener.chunk(directory, buckets);
                }
            } while ((page = response.getNextPageToken()) != null);
            return buckets;
        }
        catch (IOException e) {
            throw new GoogleStorageExceptionMappingService().map("Listing directory {0} failed", e, directory);
        }
    }
}

