/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googlestorage;

import ch.cyberduck.core.DescriptiveUrl;
import ch.cyberduck.core.DescriptiveUrlBag;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.URIEncoder;
import ch.cyberduck.core.UrlProvider;
import ch.cyberduck.core.googlestorage.GoogleStorageSession;
import ch.cyberduck.core.shared.DefaultUrlProvider;
import java.net.URI;
import java.text.MessageFormat;

public class GoogleStorageUrlProvider
implements UrlProvider {
    private final GoogleStorageSession session;

    public GoogleStorageUrlProvider(GoogleStorageSession session) {
        this.session = session;
    }

    public DescriptiveUrlBag toUrl(Path file) {
        DescriptiveUrlBag list = new DefaultUrlProvider(this.session.getHost()).toUrl(file);
        if (file.isFile()) {
            list.add(new DescriptiveUrl(URI.create(String.format("https://storage.cloud.google.com%s", URIEncoder.encode((String)file.getAbsolute()))), DescriptiveUrl.Type.authenticated, MessageFormat.format(LocaleFactory.localizedString((String)"{0} URL"), LocaleFactory.localizedString((String)"Authenticated"))));
        }
        return list;
    }
}

