/*
 * Decompiled with CFR 0.152.
 */
package com.dracoon.sdk.crypto.model;

import com.dracoon.sdk.crypto.error.UnknownVersionException;
import com.dracoon.sdk.crypto.internal.CryptoUtils;
import com.dracoon.sdk.crypto.internal.CryptoVersion;
import com.dracoon.sdk.crypto.internal.Validator;
import com.dracoon.sdk.crypto.model.UserPrivateKey;
import com.dracoon.sdk.crypto.model.UserPublicKey;

public class UserKeyPair {
    private final UserPrivateKey userPrivateKey;
    private final UserPublicKey userPublicKey;

    public UserKeyPair(UserPrivateKey userPrivateKey, UserPublicKey userPublicKey) throws IllegalArgumentException {
        Validator.validateNotNull("userPrivateKey", userPrivateKey);
        Validator.validateNotNull("userPublicKey", userPublicKey);
        Validator.validateEqual("userPublicKey.version", userPublicKey, "userPublicKey.version", userPublicKey);
        this.userPrivateKey = userPrivateKey;
        this.userPublicKey = userPublicKey;
    }

    public UserPrivateKey getUserPrivateKey() {
        return this.userPrivateKey;
    }

    public UserPublicKey getUserPublicKey() {
        return this.userPublicKey;
    }

    public static enum Version implements CryptoVersion
    {
        RSA2048("A"),
        RSA4096("RSA-4096");

        private final String value;

        private Version(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public static Version getByValue(String value) throws UnknownVersionException {
            Version v = (Version)CryptoUtils.findCryptoVersionEnum((CryptoVersion[])Version.values(), (String)value);
            if (v == null) {
                throw new UnknownVersionException("Unknown key pair version.");
            }
            return v;
        }
    }
}

