/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.azure;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.azure.AzureCopyFeature;
import ch.cyberduck.core.azure.AzureDeleteFeature;
import ch.cyberduck.core.azure.AzurePathContainerService;
import ch.cyberduck.core.azure.AzureSession;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.transfer.TransferStatus;
import com.microsoft.azure.storage.OperationContext;
import java.util.Collections;

public class AzureMoveFeature
implements Move {
    private final AzureSession session;
    private final OperationContext context;
    private final PathContainerService containerService = new AzurePathContainerService();
    private final Delete delete;

    public AzureMoveFeature(AzureSession session, OperationContext context) {
        this.session = session;
        this.delete = new AzureDeleteFeature(session, context);
        this.context = context;
    }

    public boolean isSupported(Path source, Path target) {
        return !this.containerService.isContainer(source);
    }

    public Path move(Path file, Path renamed, TransferStatus status, Delete.Callback callback, ConnectionCallback connectionCallback) throws BackgroundException {
        Path copy = new AzureCopyFeature(this.session, this.context).copy(file, renamed, new TransferStatus().length(file.attributes().getSize()), connectionCallback);
        this.delete.delete(Collections.singletonList(file), (PasswordCallback)connectionCallback, callback);
        return copy;
    }
}

