/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.VersionId;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.http.DefaultHttpResponseExceptionMappingService;
import ch.cyberduck.core.io.StreamCancelation;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.sds.SDSApiClient;
import ch.cyberduck.core.sds.SDSExceptionMappingService;
import ch.cyberduck.core.sds.SDSNodeIdProvider;
import ch.cyberduck.core.sds.SDSSession;
import ch.cyberduck.core.sds.SDSTouchFeature;
import ch.cyberduck.core.sds.io.swagger.client.ApiClient;
import ch.cyberduck.core.sds.io.swagger.client.ApiException;
import ch.cyberduck.core.sds.io.swagger.client.api.NodesApi;
import ch.cyberduck.core.sds.io.swagger.client.model.CompleteS3FileUploadRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.CreateFileUploadResponse;
import ch.cyberduck.core.sds.io.swagger.client.model.FileKey;
import ch.cyberduck.core.sds.io.swagger.client.model.GeneratePresignedUrlsRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.PresignedUrl;
import ch.cyberduck.core.sds.io.swagger.client.model.S3FileUploadPart;
import ch.cyberduck.core.sds.io.swagger.client.model.S3FileUploadStatus;
import ch.cyberduck.core.sds.triplecrypt.TripleCryptConverter;
import ch.cyberduck.core.sds.triplecrypt.TripleCryptExceptionMappingService;
import ch.cyberduck.core.threading.BackgroundExceptionCallable;
import ch.cyberduck.core.threading.DefaultRetryCallable;
import ch.cyberduck.core.threading.ScheduledThreadPool;
import ch.cyberduck.core.transfer.TransferStatus;
import com.dracoon.sdk.crypto.Crypto;
import com.dracoon.sdk.crypto.error.CryptoSystemException;
import com.dracoon.sdk.crypto.error.InvalidFileKeyException;
import com.dracoon.sdk.crypto.error.InvalidKeyPairException;
import com.dracoon.sdk.crypto.error.UnknownVersionException;
import com.dracoon.sdk.crypto.model.EncryptedFileKey;
import com.dracoon.sdk.crypto.model.PlainFileKey;
import com.dracoon.sdk.crypto.model.UserPublicKey;
import com.fasterxml.jackson.databind.ObjectReader;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class PresignedMultipartOutputStream
extends OutputStream {
    private static final Logger log = Logger.getLogger(PresignedMultipartOutputStream.class);
    private final SDSSession session;
    private final SDSNodeIdProvider nodeid;
    private final CreateFileUploadResponse createFileUploadResponse;
    private final Path file;
    private final TransferStatus overall;
    private final AtomicBoolean close = new AtomicBoolean();
    private final AtomicReference<BackgroundException> canceled = new AtomicReference();
    private Long offset = 0L;
    private int partNumber;
    private final Map<Integer, String> etags = new HashMap<Integer, String>();

    public PresignedMultipartOutputStream(SDSSession session, SDSNodeIdProvider nodeid, CreateFileUploadResponse createFileUploadResponse, Path file, TransferStatus status) {
        this.session = session;
        this.nodeid = nodeid;
        this.createFileUploadResponse = createFileUploadResponse;
        this.file = file;
        this.overall = status;
    }

    @Override
    public void write(int value) throws IOException {
        throw new IOException(new UnsupportedOperationException());
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        try {
            if (null != this.canceled.get()) {
                throw this.canceled.get();
            }
            final byte[] content = Arrays.copyOfRange(b, off, len);
            final HttpEntity entity = EntityBuilder.create().setBinary(content).build();
            new DefaultRetryCallable(this.session.getHost(), (BackgroundExceptionCallable)new BackgroundExceptionCallable<Void>(){

                /*
                 * Unable to fully structure code
                 */
                public Void call() throws BackgroundException {
                    client = (SDSApiClient)PresignedMultipartOutputStream.access$000(PresignedMultipartOutputStream.this).getClient();
                    try {
                        target = new NodesApi((ApiClient)PresignedMultipartOutputStream.access$000(PresignedMultipartOutputStream.this).getClient()).generatePresignedUrlsFiles(new GeneratePresignedUrlsRequest().firstPartNumber(PresignedMultipartOutputStream.access$104(PresignedMultipartOutputStream.this)).lastPartNumber(PresignedMultipartOutputStream.access$100(PresignedMultipartOutputStream.this)).size(Long.valueOf(content.length)), PresignedMultipartOutputStream.access$200(PresignedMultipartOutputStream.this).getUploadId(), "").getUrls();
lbl4:
                        // 4 sources

                        for (PresignedUrl url : target) {
                            request = new HttpPut(url.getUrl());
                            request.setEntity(entity);
                            request.setHeader("Content-Length", String.valueOf(entity.getContentLength()));
                            request.setHeader("Content-Type", "application/octet-stream");
                            response = client.getClient().execute((HttpUriRequest)request);
                            try {
                                switch (response.getStatusLine().getStatusCode()) {
                                    case 200: {
                                        PresignedMultipartOutputStream.access$302(PresignedMultipartOutputStream.this, PresignedMultipartOutputStream.access$300(PresignedMultipartOutputStream.this) + (long)content.length);
                                        if (response.containsHeader("ETag")) {
                                            PresignedMultipartOutputStream.access$400(PresignedMultipartOutputStream.this).put(PresignedMultipartOutputStream.access$100(PresignedMultipartOutputStream.this), response.getFirstHeader("ETag").getValue());
                                            ** break;
                                        }
                                        PresignedMultipartOutputStream.access$500().error((Object)String.format("Missing ETag in response %s", new Object[]{response}));
                                        ** break;
                                    }
                                    default: {
                                        EntityUtils.updateEntity((HttpResponse)response, (HttpEntity)new BufferedHttpEntity(response.getEntity()));
                                        throw new SDSExceptionMappingService().map(new ApiException(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), Collections.emptyMap(), EntityUtils.toString((HttpEntity)response.getEntity())));
                                    }
                                }
                            }
                            catch (BackgroundException e) {
                                PresignedMultipartOutputStream.access$600(PresignedMultipartOutputStream.this).set(e);
                                throw e;
                            }
                            finally {
                                EntityUtils.consume((HttpEntity)response.getEntity());
                            }
                        }
                    }
                    catch (ApiException e) {
                        throw new SDSExceptionMappingService().map("Upload {0} failed", e, PresignedMultipartOutputStream.access$700(PresignedMultipartOutputStream.this));
                    }
                    catch (HttpResponseException e) {
                        throw new DefaultHttpResponseExceptionMappingService().map(e);
                    }
                    catch (IOException e) {
                        throw new DefaultIOExceptionMappingService().map(e);
                    }
                    return null;
                }
            }, (StreamCancelation)this.overall).call();
        }
        catch (BackgroundException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    @Override
    public void close() throws IOException {
        block15: {
            try {
                if (this.close.get()) {
                    log.warn((Object)String.format("Skip double close of stream %s", this));
                    return;
                }
                if (null != this.canceled.get()) {
                    return;
                }
                if (this.etags.isEmpty()) {
                    new SDSTouchFeature(this.session, this.nodeid).touch(this.file, new TransferStatus());
                    break block15;
                }
                try {
                    CompleteS3FileUploadRequest completeS3FileUploadRequest = new CompleteS3FileUploadRequest().keepShareLinks(this.overall.isExists() ? PreferencesFactory.get().getBoolean("sds.upload.sharelinks.keep") : false).resolutionStrategy(this.overall.isExists() ? CompleteS3FileUploadRequest.ResolutionStrategyEnum.OVERWRITE : CompleteS3FileUploadRequest.ResolutionStrategyEnum.FAIL);
                    if (this.overall.getFilekey() != null) {
                        ObjectReader reader = ((SDSApiClient)this.session.getClient()).getJSON().getContext(null).readerFor(FileKey.class);
                        FileKey fileKey = (FileKey)reader.readValue(this.overall.getFilekey().array());
                        EncryptedFileKey encryptFileKey = Crypto.encryptFileKey((PlainFileKey)TripleCryptConverter.toCryptoPlainFileKey(fileKey), (UserPublicKey)TripleCryptConverter.toCryptoUserPublicKey(this.session.keyPair().getPublicKeyContainer()));
                        completeS3FileUploadRequest.setFileKey(TripleCryptConverter.toSwaggerFileKey(encryptFileKey));
                    }
                    this.etags.forEach((key, value) -> completeS3FileUploadRequest.addPartsItem(new S3FileUploadPart().partEtag(StringUtils.remove((String)value, (char)'\"')).partNumber((Integer)key)));
                    new NodesApi((ApiClient)this.session.getClient()).completeS3FileUpload(completeS3FileUploadRequest, this.createFileUploadResponse.getUploadId(), "");
                    ScheduledThreadPool polling = new ScheduledThreadPool();
                    final CountDownLatch done = new CountDownLatch(1);
                    final AtomicReference failure = new AtomicReference();
                    ScheduledFuture f = polling.repeat(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                S3FileUploadStatus uploadStatus = new NodesApi((ApiClient)PresignedMultipartOutputStream.this.session.getClient()).requestUploadStatusFiles(PresignedMultipartOutputStream.this.createFileUploadResponse.getUploadId(), "");
                                switch (uploadStatus.getStatus()) {
                                    case "finishing": {
                                        break;
                                    }
                                    case "transfer": {
                                        failure.set(new InteroperabilityException(uploadStatus.getStatus()));
                                        done.countDown();
                                    }
                                    case "error": {
                                        failure.set(new InteroperabilityException(uploadStatus.getErrorDetails().getMessage()));
                                        done.countDown();
                                    }
                                    case "done": {
                                        PresignedMultipartOutputStream.this.overall.setVersion(new VersionId(String.valueOf(uploadStatus.getNode().getId())));
                                        done.countDown();
                                    }
                                }
                            }
                            catch (ApiException e) {
                                done.countDown();
                                failure.set(new SDSExceptionMappingService().map("Upload {0} failed", e, PresignedMultipartOutputStream.this.file));
                            }
                        }
                    }, Long.valueOf(PreferencesFactory.get().getLong("sds.upload.s3.status.period")), TimeUnit.MILLISECONDS);
                    Uninterruptibles.awaitUninterruptibly((CountDownLatch)done);
                    polling.shutdown();
                    if (null != failure.get()) {
                        throw (BackgroundException)((Object)failure.get());
                    }
                }
                catch (CryptoSystemException | InvalidFileKeyException | InvalidKeyPairException | UnknownVersionException e) {
                    throw new TripleCryptExceptionMappingService().map("Upload {0} failed", e, this.file);
                }
                catch (ApiException e) {
                    throw new SDSExceptionMappingService().map("Upload {0} failed", e, this.file);
                }
            }
            catch (BackgroundException e) {
                throw new IOException(e);
            }
            finally {
                this.close.set(true);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PresignedMultipartOutputStream{");
        sb.append("nodeid=").append(this.nodeid);
        sb.append(", createFileUploadResponse=").append(this.createFileUploadResponse);
        sb.append(", file=").append(this.file);
        sb.append(", overall=").append(this.overall);
        sb.append(", offset=").append(this.offset);
        sb.append('}');
        return sb.toString();
    }

    public VersionId getVersionId() {
        return this.overall.getVersion();
    }

    static /* synthetic */ int access$100(PresignedMultipartOutputStream x0) {
        return x0.partNumber;
    }

    static /* synthetic */ int access$104(PresignedMultipartOutputStream x0) {
        return ++x0.partNumber;
    }

    static /* synthetic */ Long access$302(PresignedMultipartOutputStream x0, Long x1) {
        x0.offset = x1;
        return x0.offset;
    }

    static /* synthetic */ Long access$300(PresignedMultipartOutputStream x0) {
        return x0.offset;
    }

    static /* synthetic */ Map access$400(PresignedMultipartOutputStream x0) {
        return x0.etags;
    }

    static /* synthetic */ Logger access$500() {
        return log;
    }

    static /* synthetic */ AtomicReference access$600(PresignedMultipartOutputStream x0) {
        return x0.canceled;
    }
}

