/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds;

import ch.cyberduck.core.AlphanumericRandomStringService;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.VersionId;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.HttpUploadFeature;
import ch.cyberduck.core.io.BandwidthThrottle;
import ch.cyberduck.core.io.Buffer;
import ch.cyberduck.core.io.BufferOutputStream;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.io.FileBuffer;
import ch.cyberduck.core.io.StatusOutputStream;
import ch.cyberduck.core.io.StreamCancelation;
import ch.cyberduck.core.io.StreamCopier;
import ch.cyberduck.core.io.StreamListener;
import ch.cyberduck.core.io.StreamProgress;
import ch.cyberduck.core.local.TemporaryFileServiceFactory;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.sds.SDSApiClient;
import ch.cyberduck.core.sds.SDSExceptionMappingService;
import ch.cyberduck.core.sds.SDSNodeIdProvider;
import ch.cyberduck.core.sds.SDSSession;
import ch.cyberduck.core.sds.io.swagger.client.ApiClient;
import ch.cyberduck.core.sds.io.swagger.client.ApiException;
import ch.cyberduck.core.sds.io.swagger.client.api.NodesApi;
import ch.cyberduck.core.sds.io.swagger.client.model.CompleteS3FileUploadRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.CreateFileUploadRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.CreateFileUploadResponse;
import ch.cyberduck.core.sds.io.swagger.client.model.FileKey;
import ch.cyberduck.core.sds.io.swagger.client.model.GeneratePresignedUrlsRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.PresignedUrl;
import ch.cyberduck.core.sds.io.swagger.client.model.S3FileUploadPart;
import ch.cyberduck.core.sds.io.swagger.client.model.S3FileUploadStatus;
import ch.cyberduck.core.sds.triplecrypt.TripleCryptConverter;
import ch.cyberduck.core.sds.triplecrypt.TripleCryptExceptionMappingService;
import ch.cyberduck.core.sds.triplecrypt.TripleCryptOutputStream;
import ch.cyberduck.core.threading.BackgroundExceptionCallable;
import ch.cyberduck.core.threading.DefaultRetryCallable;
import ch.cyberduck.core.threading.ScheduledThreadPool;
import ch.cyberduck.core.threading.ThreadPool;
import ch.cyberduck.core.threading.ThreadPoolFactory;
import ch.cyberduck.core.transfer.TransferStatus;
import com.dracoon.sdk.crypto.Crypto;
import com.dracoon.sdk.crypto.error.CryptoSystemException;
import com.dracoon.sdk.crypto.error.InvalidFileKeyException;
import com.dracoon.sdk.crypto.error.InvalidKeyPairException;
import com.dracoon.sdk.crypto.error.UnknownVersionException;
import com.dracoon.sdk.crypto.model.EncryptedFileKey;
import com.dracoon.sdk.crypto.model.PlainFileKey;
import com.dracoon.sdk.crypto.model.UserPublicKey;
import com.fasterxml.jackson.databind.ObjectReader;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;

public class SDSDirectS3UploadFeature
extends HttpUploadFeature<VersionId, MessageDigest> {
    private static final Logger log = Logger.getLogger(SDSDirectS3UploadFeature.class);
    public static final int MAXIMUM_UPLOAD_PARTS = 10000;
    private final SDSSession session;
    private final SDSNodeIdProvider nodeid;
    private final Long partsize;
    private final Integer concurrency;

    public SDSDirectS3UploadFeature(SDSSession session, SDSNodeIdProvider nodeid, Write<VersionId> writer) {
        this(session, nodeid, writer, PreferencesFactory.get().getLong("s3.upload.multipart.size"), PreferencesFactory.get().getInteger("s3.upload.multipart.concurrency"));
    }

    public SDSDirectS3UploadFeature(SDSSession session, SDSNodeIdProvider nodeid, Write<VersionId> writer, Long partsize, Integer concurrency) {
        super(writer);
        this.session = session;
        this.nodeid = nodeid;
        this.partsize = partsize;
        this.concurrency = concurrency;
    }

    public VersionId upload(final Path file, Local local, BandwidthThrottle throttle, StreamListener listener, final TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        ThreadPool pool = ThreadPoolFactory.get((String)"multipart", (int)this.concurrency);
        try {
            Buffer buffer;
            Local source;
            CreateFileUploadRequest createFileUploadRequest = new CreateFileUploadRequest().directS3Upload(true).timestampModification(status.getTimestamp() == null ? null : new DateTime((Object)status.getTimestamp())).size(-1L == status.getLength() ? null : Long.valueOf(status.getLength())).parentId(Long.parseLong(this.nodeid.getFileid(file.getParent(), (ListProgressListener)new DisabledListProgressListener()))).name(file.getName());
            final CreateFileUploadResponse createFileUploadResponse = new NodesApi((ApiClient)this.session.getClient()).createFileUploadChannel(createFileUploadRequest, "");
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("upload started for %s with response %s", file, createFileUploadResponse));
            }
            HashMap<Integer, TransferStatus> etags = new HashMap<Integer, TransferStatus>();
            List<PresignedUrl> presignedUrls = this.retrievePresignedUrls(createFileUploadResponse, status);
            ArrayList<Future<TransferStatus>> parts = new ArrayList<Future<TransferStatus>>();
            if (this.nodeid.isEncrypted(file)) {
                TripleCryptOutputStream<TransferStatus> out;
                source = TemporaryFileServiceFactory.get().create(new AlphanumericRandomStringService().random());
                buffer = new FileBuffer(source);
                BufferOutputStream temporary = new BufferOutputStream(buffer);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Pre-compute file key tag for upload to S3 for %s", file));
                }
                InputStream in = local.getInputStream();
                try {
                    ObjectReader reader = ((SDSApiClient)this.session.getClient()).getJSON().getContext(null).readerFor(FileKey.class);
                    FileKey fileKey = (FileKey)reader.readValue(status.getFilekey().array());
                    out = new TripleCryptOutputStream<TransferStatus>(this.session, new StatusOutputStream<TransferStatus>((OutputStream)temporary){

                        public TransferStatus getStatus() {
                            return status;
                        }
                    }, Crypto.createFileEncryptionCipher((PlainFileKey)TripleCryptConverter.toCryptoPlainFileKey(fileKey)), status);
                }
                catch (CryptoSystemException e) {
                    throw new TripleCryptExceptionMappingService().map("Upload {0} failed", e, file);
                }
                new StreamCopier((StreamCancelation)status, (StreamProgress)new TransferStatus()).transfer(in, out);
            } else {
                source = local;
                buffer = Buffer.NULL;
            }
            long size = status.getLength() + status.getOffset();
            long offset = 0L;
            long remaining = status.getLength();
            int partNumber = 1;
            while (remaining > 0L) {
                long l = Math.min(Math.max(size / 9999L, this.partsize), remaining);
                PresignedUrl presignedUrl = presignedUrls.get(partNumber - 1);
                parts.add(this.submit(pool, file, source, throttle, listener, status, presignedUrl.getUrl(), presignedUrl.getPartNumber(), offset, l, callback));
                remaining -= l;
                offset += l;
                ++partNumber;
            }
            for (Future future : parts) {
                try {
                    TransferStatus part = (TransferStatus)future.get();
                    etags.put(part.getPart(), part);
                }
                catch (InterruptedException e) {
                    log.error((Object)"Part upload failed with interrupt failure");
                    status.setCanceled();
                    throw new ConnectionCanceledException((Throwable)e);
                }
                catch (ExecutionException e) {
                    log.warn((Object)String.format("Part upload failed with execution failure %s", e.getMessage()));
                    if (e.getCause() instanceof BackgroundException) {
                        throw (BackgroundException)e.getCause();
                    }
                    throw new BackgroundException(e.getCause());
                }
            }
            if (this.nodeid.isEncrypted(file)) {
                buffer.close();
            }
            CompleteS3FileUploadRequest completeS3FileUploadRequest = new CompleteS3FileUploadRequest().keepShareLinks(status.isExists() ? PreferencesFactory.get().getBoolean("sds.upload.sharelinks.keep") : false).resolutionStrategy(status.isExists() ? CompleteS3FileUploadRequest.ResolutionStrategyEnum.OVERWRITE : CompleteS3FileUploadRequest.ResolutionStrategyEnum.FAIL);
            if (status.getFilekey() != null) {
                ObjectReader objectReader = ((SDSApiClient)this.session.getClient()).getJSON().getContext(null).readerFor(FileKey.class);
                FileKey fileKey = (FileKey)objectReader.readValue(status.getFilekey().array());
                EncryptedFileKey encryptFileKey = Crypto.encryptFileKey((PlainFileKey)TripleCryptConverter.toCryptoPlainFileKey(fileKey), (UserPublicKey)TripleCryptConverter.toCryptoUserPublicKey(this.session.keyPair().getPublicKeyContainer()));
                completeS3FileUploadRequest.setFileKey(TripleCryptConverter.toSwaggerFileKey(encryptFileKey));
            }
            etags.forEach((key, value) -> completeS3FileUploadRequest.addPartsItem(new S3FileUploadPart().partEtag(value.getChecksum().hash).partNumber((Integer)key)));
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Complete file upload with %s for %s", completeS3FileUploadRequest, file));
            }
            new NodesApi((ApiClient)this.session.getClient()).completeS3FileUpload(completeS3FileUploadRequest, createFileUploadResponse.getUploadId(), "");
            ScheduledThreadPool scheduledThreadPool = new ScheduledThreadPool();
            final CountDownLatch done = new CountDownLatch(1);
            final AtomicReference failure = new AtomicReference();
            ScheduledFuture f = scheduledThreadPool.repeat(new Runnable(){

                @Override
                public void run() {
                    try {
                        S3FileUploadStatus uploadStatus = new NodesApi((ApiClient)SDSDirectS3UploadFeature.this.session.getClient()).requestUploadStatusFiles(createFileUploadResponse.getUploadId(), "");
                        switch (uploadStatus.getStatus()) {
                            case "finishing": {
                                break;
                            }
                            case "transfer": {
                                failure.set(new InteroperabilityException(uploadStatus.getStatus()));
                                done.countDown();
                                break;
                            }
                            case "error": {
                                failure.set(new InteroperabilityException(uploadStatus.getErrorDetails().getMessage()));
                                done.countDown();
                                break;
                            }
                            case "done": {
                                status.setVersion(new VersionId(String.valueOf(uploadStatus.getNode().getId())));
                                done.countDown();
                            }
                        }
                    }
                    catch (ApiException e) {
                        done.countDown();
                        failure.set(new SDSExceptionMappingService().map("Upload {0} failed", e, file));
                    }
                }
            }, Long.valueOf(PreferencesFactory.get().getLong("sds.upload.s3.status.period")), TimeUnit.MILLISECONDS);
            Uninterruptibles.awaitUninterruptibly((CountDownLatch)done);
            scheduledThreadPool.shutdown();
            if (null != failure.get()) {
                throw (BackgroundException)failure.get();
            }
            status.setComplete();
            VersionId versionId = status.getVersion();
            return versionId;
        }
        catch (CryptoSystemException | InvalidFileKeyException | InvalidKeyPairException | UnknownVersionException e) {
            throw new TripleCryptExceptionMappingService().map("Upload {0} failed", e, file);
        }
        catch (ApiException e) {
            throw new SDSExceptionMappingService().map("Upload {0} failed", e, file);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
        finally {
            pool.shutdown(false);
        }
    }

    private List<PresignedUrl> retrievePresignedUrls(CreateFileUploadResponse createFileUploadResponse, TransferStatus status) throws ApiException {
        long size = status.getLength() + status.getOffset();
        ArrayList<PresignedUrl> presignedUrls = new ArrayList<PresignedUrl>();
        GeneratePresignedUrlsRequest presignedUrlsRequest = new GeneratePresignedUrlsRequest().firstPartNumber(1);
        long remaining = status.getLength();
        int partNumber = 1;
        while (remaining > 0L) {
            long length = Math.min(Math.max(size / 9999L, this.partsize), remaining);
            if (partNumber > 1 && length < Math.max(size / 9999L, this.partsize)) {
                presignedUrls.addAll(new NodesApi((ApiClient)this.session.getClient()).generatePresignedUrlsFiles(new GeneratePresignedUrlsRequest().firstPartNumber(partNumber).lastPartNumber(partNumber).size(length), createFileUploadResponse.getUploadId(), "").getUrls());
            } else {
                presignedUrlsRequest.lastPartNumber(partNumber).size(length);
            }
            remaining -= length;
            ++partNumber;
        }
        presignedUrls.addAll(0, new NodesApi((ApiClient)this.session.getClient()).generatePresignedUrlsFiles(presignedUrlsRequest, createFileUploadResponse.getUploadId(), "").getUrls());
        return presignedUrls;
    }

    private Future<TransferStatus> submit(ThreadPool pool, final Path file, final Local local, final BandwidthThrottle throttle, final StreamListener listener, final TransferStatus overall, final String url, final Integer partNumber, final long offset, final long length, final ConnectionCallback callback) {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Submit part %d of %s to queue with offset %d and length %d", partNumber, file, offset, length));
        }
        return pool.execute((Callable)new DefaultRetryCallable(this.session.getHost(), (BackgroundExceptionCallable)new BackgroundExceptionCallable<TransferStatus>(){

            public TransferStatus call() throws BackgroundException {
                overall.validate();
                final TransferStatus status = new TransferStatus().segment(true).length(length).skip(offset);
                status.setUrl(url);
                status.setPart(partNumber);
                status.setHeader(overall.getHeader());
                status.setNonces(overall.getNonces());
                status.setFilekey(overall.getFilekey());
                VersionId part = (VersionId)SDSDirectS3UploadFeature.super.upload(file, local, throttle, listener, status, (StreamCancelation)overall, new StreamProgress(){

                    public void progress(long bytes) {
                        status.progress(bytes);
                        overall.progress(bytes);
                    }

                    public void setComplete() {
                        status.setComplete();
                    }
                }, callback);
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("Received response %s for part number %d", part, partNumber));
                }
                status.setChecksum(Checksum.parse((String)part.id));
                return status;
            }
        }, (StreamCancelation)overall));
    }
}

