/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.model;

import ch.cyberduck.core.sds.io.swagger.client.model.ObjectExpiration;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.joda.time.DateTime;

@Schema(description="Request model for creating an upload channel")
public class CreateFileUploadRequest {
    @JsonProperty(value="parentId")
    private Long parentId = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="classification")
    private ClassificationEnum classification = null;
    @JsonProperty(value="size")
    private Long size = null;
    @JsonProperty(value="expiration")
    private ObjectExpiration expiration = null;
    @JsonProperty(value="notes")
    private String notes = null;
    @JsonProperty(value="directS3Upload")
    private Boolean directS3Upload = false;
    @JsonProperty(value="timestampCreation")
    private DateTime timestampCreation = null;
    @JsonProperty(value="timestampModification")
    private DateTime timestampModification = null;

    public CreateFileUploadRequest parentId(Long parentId) {
        this.parentId = parentId;
        return this;
    }

    @Schema(required=true, description="Parent node ID (room or folder)")
    public Long getParentId() {
        return this.parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public CreateFileUploadRequest name(String name) {
        this.name = name;
        return this;
    }

    @Schema(required=true, description="File name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CreateFileUploadRequest classification(ClassificationEnum classification) {
        this.classification = classification;
        return this;
    }

    @Schema(description="Classification ID:  * `1` - public  * `2` - internal  * `3` - confidential  * `4` - strictly confidential    (default: classification from parent room)")
    public ClassificationEnum getClassification() {
        return this.classification;
    }

    public void setClassification(ClassificationEnum classification) {
        this.classification = classification;
    }

    public CreateFileUploadRequest size(Long size) {
        this.size = size;
        return this;
    }

    @Schema(description="File size in byte")
    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public CreateFileUploadRequest expiration(ObjectExpiration expiration) {
        this.expiration = expiration;
        return this;
    }

    @Schema(description="")
    public ObjectExpiration getExpiration() {
        return this.expiration;
    }

    public void setExpiration(ObjectExpiration expiration) {
        this.expiration = expiration;
    }

    public CreateFileUploadRequest notes(String notes) {
        this.notes = notes;
        return this;
    }

    @Schema(description="User notes  Use empty string to remove.")
    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public CreateFileUploadRequest directS3Upload(Boolean directS3Upload) {
        this.directS3Upload = directS3Upload;
        return this;
    }

    @Schema(description="&#128640; Since v4.15.0  Upload direct to S3")
    public Boolean isDirectS3Upload() {
        return this.directS3Upload;
    }

    public void setDirectS3Upload(Boolean directS3Upload) {
        this.directS3Upload = directS3Upload;
    }

    public CreateFileUploadRequest timestampCreation(DateTime timestampCreation) {
        this.timestampCreation = timestampCreation;
        return this;
    }

    @Schema(required=true, description="&#128640; Since v4.22.0  Time the node was created on external file system  (default: current server datetime in UTC format)")
    public DateTime getTimestampCreation() {
        return this.timestampCreation;
    }

    public void setTimestampCreation(DateTime timestampCreation) {
        this.timestampCreation = timestampCreation;
    }

    public CreateFileUploadRequest timestampModification(DateTime timestampModification) {
        this.timestampModification = timestampModification;
        return this;
    }

    @Schema(required=true, description="&#128640; Since v4.22.0  Time the content of a node was last modified on external file system  (default: current server datetime in UTC format)")
    public DateTime getTimestampModification() {
        return this.timestampModification;
    }

    public void setTimestampModification(DateTime timestampModification) {
        this.timestampModification = timestampModification;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateFileUploadRequest createFileUploadRequest = (CreateFileUploadRequest)o;
        return Objects.equals(this.parentId, createFileUploadRequest.parentId) && Objects.equals(this.name, createFileUploadRequest.name) && Objects.equals((Object)this.classification, (Object)createFileUploadRequest.classification) && Objects.equals(this.size, createFileUploadRequest.size) && Objects.equals(this.expiration, createFileUploadRequest.expiration) && Objects.equals(this.notes, createFileUploadRequest.notes) && Objects.equals(this.directS3Upload, createFileUploadRequest.directS3Upload) && Objects.equals(this.timestampCreation, createFileUploadRequest.timestampCreation) && Objects.equals(this.timestampModification, createFileUploadRequest.timestampModification);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.parentId, this.name, this.classification, this.size, this.expiration, this.notes, this.directS3Upload, this.timestampCreation, this.timestampModification});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateFileUploadRequest {\n");
        sb.append("    parentId: ").append(this.toIndentedString(this.parentId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    classification: ").append(this.toIndentedString((Object)this.classification)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    expiration: ").append(this.toIndentedString(this.expiration)).append("\n");
        sb.append("    notes: ").append(this.toIndentedString(this.notes)).append("\n");
        sb.append("    directS3Upload: ").append(this.toIndentedString(this.directS3Upload)).append("\n");
        sb.append("    timestampCreation: ").append(this.toIndentedString(this.timestampCreation)).append("\n");
        sb.append("    timestampModification: ").append(this.toIndentedString(this.timestampModification)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ClassificationEnum {
        NUMBER_1(1),
        NUMBER_2(2),
        NUMBER_3(3),
        NUMBER_4(4);

        private Integer value;

        private ClassificationEnum(Integer value) {
            this.value = value;
        }

        @JsonValue
        public Integer getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ClassificationEnum fromValue(String text) {
            for (ClassificationEnum b : ClassificationEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

