/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Request model for generating presigned URLs")
public class GeneratePresignedUrlsRequest {
    @JsonProperty(value="size")
    private Long size = null;
    @JsonProperty(value="firstPartNumber")
    private Integer firstPartNumber = null;
    @JsonProperty(value="lastPartNumber")
    private Integer lastPartNumber = null;

    public GeneratePresignedUrlsRequest size(Long size) {
        this.size = size;
        return this;
    }

    @Schema(required=true, description="`Content-Length` header size for each presigned URL (in bytes)  *MUST* be >= 5 MB except the last part.")
    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public GeneratePresignedUrlsRequest firstPartNumber(Integer firstPartNumber) {
        this.firstPartNumber = firstPartNumber;
        return this;
    }

    @Schema(required=true, description="First part number of a range of requested presigned URLs (for S3 it is: `1`)")
    public Integer getFirstPartNumber() {
        return this.firstPartNumber;
    }

    public void setFirstPartNumber(Integer firstPartNumber) {
        this.firstPartNumber = firstPartNumber;
    }

    public GeneratePresignedUrlsRequest lastPartNumber(Integer lastPartNumber) {
        this.lastPartNumber = lastPartNumber;
        return this;
    }

    @Schema(required=true, description="Last part number of a range of requested presigned URLs")
    public Integer getLastPartNumber() {
        return this.lastPartNumber;
    }

    public void setLastPartNumber(Integer lastPartNumber) {
        this.lastPartNumber = lastPartNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeneratePresignedUrlsRequest generatePresignedUrlsRequest = (GeneratePresignedUrlsRequest)o;
        return Objects.equals(this.size, generatePresignedUrlsRequest.size) && Objects.equals(this.firstPartNumber, generatePresignedUrlsRequest.firstPartNumber) && Objects.equals(this.lastPartNumber, generatePresignedUrlsRequest.lastPartNumber);
    }

    public int hashCode() {
        return Objects.hash(this.size, this.firstPartNumber, this.lastPartNumber);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GeneratePresignedUrlsRequest {\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    firstPartNumber: ").append(this.toIndentedString(this.firstPartNumber)).append("\n");
        sb.append("    lastPartNumber: ").append(this.toIndentedString(this.lastPartNumber)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

