/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.joda.time.DateTime;

@Schema(description="OAuth authorization")
public class OAuthAuthorization {
    @JsonProperty(value="clientId")
    private String clientId = null;
    @JsonProperty(value="clientName")
    private String clientName = null;
    @JsonProperty(value="userAgentCategory")
    private UserAgentCategoryEnum userAgentCategory = null;
    @JsonProperty(value="id")
    private Long id = null;
    @JsonProperty(value="isStandard")
    private Boolean isStandard = null;
    @JsonProperty(value="createdAt")
    private DateTime createdAt = null;
    @JsonProperty(value="usedAt")
    private DateTime usedAt = null;
    @JsonProperty(value="expiresAt")
    private DateTime expiresAt = null;
    @JsonProperty(value="userAgentType")
    private String userAgentType = null;
    @JsonProperty(value="userAgentOs")
    private String userAgentOs = null;
    @JsonProperty(value="userAgentInfo")
    private String userAgentInfo = null;

    public OAuthAuthorization clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Schema(required=true, description="ID of the OAuth client")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public OAuthAuthorization clientName(String clientName) {
        this.clientName = clientName;
        return this;
    }

    @Schema(required=true, description="Name, which is shown at the client configuration and authorization.")
    public String getClientName() {
        return this.clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public OAuthAuthorization userAgentCategory(UserAgentCategoryEnum userAgentCategory) {
        this.userAgentCategory = userAgentCategory;
        return this;
    }

    @Schema(required=true, description="&#128640; Since v4.12.0  User agent category.")
    public UserAgentCategoryEnum getUserAgentCategory() {
        return this.userAgentCategory;
    }

    public void setUserAgentCategory(UserAgentCategoryEnum userAgentCategory) {
        this.userAgentCategory = userAgentCategory;
    }

    public OAuthAuthorization id(Long id) {
        this.id = id;
        return this;
    }

    @Schema(description="&#128640; Since v4.12.0  ID of the OAuth authorization")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public OAuthAuthorization isStandard(Boolean isStandard) {
        this.isStandard = isStandard;
        return this;
    }

    @Schema(description="&#128640; Since v4.12.0  Determines whether client is a standard client.")
    public Boolean isIsStandard() {
        return this.isStandard;
    }

    public void setIsStandard(Boolean isStandard) {
        this.isStandard = isStandard;
    }

    public OAuthAuthorization createdAt(DateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Schema(description="&#128640; Since v4.13.0  Creation date of the authorization")
    public DateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(DateTime createdAt) {
        this.createdAt = createdAt;
    }

    public OAuthAuthorization usedAt(DateTime usedAt) {
        this.usedAt = usedAt;
        return this;
    }

    @Schema(description="&#128640; Since v4.13.0  Usage date of the authorization  (Time of last usage.)")
    public DateTime getUsedAt() {
        return this.usedAt;
    }

    public void setUsedAt(DateTime usedAt) {
        this.usedAt = usedAt;
    }

    public OAuthAuthorization expiresAt(DateTime expiresAt) {
        this.expiresAt = expiresAt;
        return this;
    }

    @Schema(description="Expiration date of the authorization")
    public DateTime getExpiresAt() {
        return this.expiresAt;
    }

    public void setExpiresAt(DateTime expiresAt) {
        this.expiresAt = expiresAt;
    }

    public OAuthAuthorization userAgentType(String userAgentType) {
        this.userAgentType = userAgentType;
        return this;
    }

    @Schema(description="&#128640; Since v4.12.0  User agent type.")
    public String getUserAgentType() {
        return this.userAgentType;
    }

    public void setUserAgentType(String userAgentType) {
        this.userAgentType = userAgentType;
    }

    public OAuthAuthorization userAgentOs(String userAgentOs) {
        this.userAgentOs = userAgentOs;
        return this;
    }

    @Schema(description="&#128640; Since v4.12.0  User agent OS.")
    public String getUserAgentOs() {
        return this.userAgentOs;
    }

    public void setUserAgentOs(String userAgentOs) {
        this.userAgentOs = userAgentOs;
    }

    public OAuthAuthorization userAgentInfo(String userAgentInfo) {
        this.userAgentInfo = userAgentInfo;
        return this;
    }

    @Schema(description="&#128640; Since v4.12.0  User agent info.")
    public String getUserAgentInfo() {
        return this.userAgentInfo;
    }

    public void setUserAgentInfo(String userAgentInfo) {
        this.userAgentInfo = userAgentInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAuthAuthorization oauthAuthorization = (OAuthAuthorization)o;
        return Objects.equals(this.clientId, oauthAuthorization.clientId) && Objects.equals(this.clientName, oauthAuthorization.clientName) && Objects.equals((Object)this.userAgentCategory, (Object)oauthAuthorization.userAgentCategory) && Objects.equals(this.id, oauthAuthorization.id) && Objects.equals(this.isStandard, oauthAuthorization.isStandard) && Objects.equals(this.createdAt, oauthAuthorization.createdAt) && Objects.equals(this.usedAt, oauthAuthorization.usedAt) && Objects.equals(this.expiresAt, oauthAuthorization.expiresAt) && Objects.equals(this.userAgentType, oauthAuthorization.userAgentType) && Objects.equals(this.userAgentOs, oauthAuthorization.userAgentOs) && Objects.equals(this.userAgentInfo, oauthAuthorization.userAgentInfo);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.clientId, this.clientName, this.userAgentCategory, this.id, this.isStandard, this.createdAt, this.usedAt, this.expiresAt, this.userAgentType, this.userAgentOs, this.userAgentInfo});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OAuthAuthorization {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    clientName: ").append(this.toIndentedString(this.clientName)).append("\n");
        sb.append("    userAgentCategory: ").append(this.toIndentedString((Object)this.userAgentCategory)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    isStandard: ").append(this.toIndentedString(this.isStandard)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    usedAt: ").append(this.toIndentedString(this.usedAt)).append("\n");
        sb.append("    expiresAt: ").append(this.toIndentedString(this.expiresAt)).append("\n");
        sb.append("    userAgentType: ").append(this.toIndentedString(this.userAgentType)).append("\n");
        sb.append("    userAgentOs: ").append(this.toIndentedString(this.userAgentOs)).append("\n");
        sb.append("    userAgentInfo: ").append(this.toIndentedString(this.userAgentInfo)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum UserAgentCategoryEnum {
        BROWSER("browser"),
        NATIVE("native"),
        UNKNOWN("unknown");

        private String value;

        private UserAgentCategoryEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static UserAgentCategoryEnum fromValue(String text) {
            for (UserAgentCategoryEnum b : UserAgentCategoryEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

