/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.model;

import ch.cyberduck.core.sds.io.swagger.client.model.CustomerData;
import ch.cyberduck.core.sds.io.swagger.client.model.RoleList;
import ch.cyberduck.core.sds.io.swagger.client.model.UserAttributes;
import ch.cyberduck.core.sds.io.swagger.client.model.UserAuthData;
import ch.cyberduck.core.sds.io.swagger.client.model.UserAuthMethod;
import ch.cyberduck.core.sds.io.swagger.client.model.UserGroup;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.joda.time.DateTime;

@Schema(description="User information")
public class UserAccount {
    @JsonProperty(value="id")
    private Long id = null;
    @JsonProperty(value="userName")
    private String userName = null;
    @JsonProperty(value="firstName")
    private String firstName = null;
    @JsonProperty(value="lastName")
    private String lastName = null;
    @JsonProperty(value="isLocked")
    private Boolean isLocked = false;
    @JsonProperty(value="hasManageableRooms")
    private Boolean hasManageableRooms = null;
    @JsonProperty(value="userRoles")
    private RoleList userRoles = null;
    @JsonProperty(value="language")
    private String language = null;
    @JsonProperty(value="authData")
    private UserAuthData authData = null;
    @JsonProperty(value="mustSetEmail")
    private Boolean mustSetEmail = false;
    @JsonProperty(value="needsToAcceptEULA")
    private Boolean needsToAcceptEULA = null;
    @JsonProperty(value="expireAt")
    private DateTime expireAt = null;
    @JsonProperty(value="isEncryptionEnabled")
    private Boolean isEncryptionEnabled = null;
    @JsonProperty(value="lastLoginSuccessAt")
    private DateTime lastLoginSuccessAt = null;
    @JsonProperty(value="lastLoginFailAt")
    private DateTime lastLoginFailAt = null;
    @JsonProperty(value="email")
    private String email = null;
    @JsonProperty(value="phone")
    private String phone = null;
    @JsonProperty(value="homeRoomId")
    private Long homeRoomId = null;
    @JsonProperty(value="userGroups")
    private List<UserGroup> userGroups = null;
    @JsonProperty(value="userAttributes")
    private UserAttributes userAttributes = null;
    @JsonProperty(value="title")
    private String title = null;
    @JsonProperty(value="lastLoginSuccessIp")
    private String lastLoginSuccessIp = null;
    @JsonProperty(value="lastLoginFailIp")
    private String lastLoginFailIp = null;
    @JsonProperty(value="gender")
    private String gender = "n";
    @JsonProperty(value="needsToChangeUserName")
    private Boolean needsToChangeUserName = false;
    @JsonProperty(value="authMethods")
    private List<UserAuthMethod> authMethods = null;
    @JsonProperty(value="login")
    private String login = null;
    @JsonProperty(value="lockStatus")
    private Integer lockStatus = null;
    @JsonProperty(value="customer")
    private CustomerData customer = null;
    @JsonProperty(value="needsToChangePassword")
    private Boolean needsToChangePassword = null;

    public UserAccount id(Long id) {
        this.id = id;
        return this;
    }

    @Schema(required=true, description="Unique identifier for the user")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public UserAccount userName(String userName) {
        this.userName = userName;
        return this;
    }

    @Schema(required=true, description="&#128640; Since v4.13.0  Username")
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public UserAccount firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    @Schema(required=true, description="User first name")
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public UserAccount lastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    @Schema(required=true, description="User last name")
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public UserAccount isLocked(Boolean isLocked) {
        this.isLocked = isLocked;
        return this;
    }

    @Schema(required=true, description="User is locked:  * `false` - unlocked  * `true` - locked    User is locked and can not login anymore.")
    public Boolean isIsLocked() {
        return this.isLocked;
    }

    public void setIsLocked(Boolean isLocked) {
        this.isLocked = isLocked;
    }

    public UserAccount hasManageableRooms(Boolean hasManageableRooms) {
        this.hasManageableRooms = hasManageableRooms;
        return this;
    }

    @Schema(required=true, description="User has manageable rooms")
    public Boolean isHasManageableRooms() {
        return this.hasManageableRooms;
    }

    public void setHasManageableRooms(Boolean hasManageableRooms) {
        this.hasManageableRooms = hasManageableRooms;
    }

    public UserAccount userRoles(RoleList userRoles) {
        this.userRoles = userRoles;
        return this;
    }

    @Schema(required=true, description="")
    public RoleList getUserRoles() {
        return this.userRoles;
    }

    public void setUserRoles(RoleList userRoles) {
        this.userRoles = userRoles;
    }

    public UserAccount language(String language) {
        this.language = language;
        return this;
    }

    @Schema(required=true, description="&#128640; Since v4.20.0  IETF language tag")
    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public UserAccount authData(UserAuthData authData) {
        this.authData = authData;
        return this;
    }

    @Schema(required=true, description="")
    public UserAuthData getAuthData() {
        return this.authData;
    }

    public void setAuthData(UserAuthData authData) {
        this.authData = authData;
    }

    public UserAccount mustSetEmail(Boolean mustSetEmail) {
        this.mustSetEmail = mustSetEmail;
        return this;
    }

    @Schema(description="&#128640; Since v4.13.0  If `true`, the user must set the `email` at the first login.")
    public Boolean isMustSetEmail() {
        return this.mustSetEmail;
    }

    public void setMustSetEmail(Boolean mustSetEmail) {
        this.mustSetEmail = mustSetEmail;
    }

    public UserAccount needsToAcceptEULA(Boolean needsToAcceptEULA) {
        this.needsToAcceptEULA = needsToAcceptEULA;
        return this;
    }

    @Schema(description="User has accepted EULA.  Present, if EULA is system global active.  cf. `GET system/config/settings/general` - `eulaEnabled`")
    public Boolean isNeedsToAcceptEULA() {
        return this.needsToAcceptEULA;
    }

    public void setNeedsToAcceptEULA(Boolean needsToAcceptEULA) {
        this.needsToAcceptEULA = needsToAcceptEULA;
    }

    public UserAccount expireAt(DateTime expireAt) {
        this.expireAt = expireAt;
        return this;
    }

    @Schema(description="Expiration date")
    public DateTime getExpireAt() {
        return this.expireAt;
    }

    public void setExpireAt(DateTime expireAt) {
        this.expireAt = expireAt;
    }

    public UserAccount isEncryptionEnabled(Boolean isEncryptionEnabled) {
        this.isEncryptionEnabled = isEncryptionEnabled;
        return this;
    }

    @Schema(description="User has generated private key.  Possible if client-side encryption is active for this customer")
    public Boolean isIsEncryptionEnabled() {
        return this.isEncryptionEnabled;
    }

    public void setIsEncryptionEnabled(Boolean isEncryptionEnabled) {
        this.isEncryptionEnabled = isEncryptionEnabled;
    }

    public UserAccount lastLoginSuccessAt(DateTime lastLoginSuccessAt) {
        this.lastLoginSuccessAt = lastLoginSuccessAt;
        return this;
    }

    @Schema(description="Last successful logon date")
    public DateTime getLastLoginSuccessAt() {
        return this.lastLoginSuccessAt;
    }

    public void setLastLoginSuccessAt(DateTime lastLoginSuccessAt) {
        this.lastLoginSuccessAt = lastLoginSuccessAt;
    }

    public UserAccount lastLoginFailAt(DateTime lastLoginFailAt) {
        this.lastLoginFailAt = lastLoginFailAt;
        return this;
    }

    @Schema(description="Last failed logon date")
    public DateTime getLastLoginFailAt() {
        return this.lastLoginFailAt;
    }

    public void setLastLoginFailAt(DateTime lastLoginFailAt) {
        this.lastLoginFailAt = lastLoginFailAt;
    }

    public UserAccount email(String email) {
        this.email = email;
        return this;
    }

    @Schema(description="Email ")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public UserAccount phone(String phone) {
        this.phone = phone;
        return this;
    }

    @Schema(description="Phone number")
    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public UserAccount homeRoomId(Long homeRoomId) {
        this.homeRoomId = homeRoomId;
        return this;
    }

    @Schema(description="Homeroom ID")
    public Long getHomeRoomId() {
        return this.homeRoomId;
    }

    public void setHomeRoomId(Long homeRoomId) {
        this.homeRoomId = homeRoomId;
    }

    public UserAccount userGroups(List<UserGroup> userGroups) {
        this.userGroups = userGroups;
        return this;
    }

    public UserAccount addUserGroupsItem(UserGroup userGroupsItem) {
        if (this.userGroups == null) {
            this.userGroups = new ArrayList<UserGroup>();
        }
        this.userGroups.add(userGroupsItem);
        return this;
    }

    @Schema(description="All groups the user is member of")
    public List<UserGroup> getUserGroups() {
        return this.userGroups;
    }

    public void setUserGroups(List<UserGroup> userGroups) {
        this.userGroups = userGroups;
    }

    public UserAccount userAttributes(UserAttributes userAttributes) {
        this.userAttributes = userAttributes;
        return this;
    }

    @Schema(description="")
    public UserAttributes getUserAttributes() {
        return this.userAttributes;
    }

    public void setUserAttributes(UserAttributes userAttributes) {
        this.userAttributes = userAttributes;
    }

    public UserAccount title(String title) {
        this.title = title;
        return this;
    }

    @Schema(description="&#128679; Deprecated since v4.18.0  Job title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public UserAccount lastLoginSuccessIp(String lastLoginSuccessIp) {
        this.lastLoginSuccessIp = lastLoginSuccessIp;
        return this;
    }

    @Schema(description="&#128679; Deprecated since v4.6.0  Last successful logon IP address")
    public String getLastLoginSuccessIp() {
        return this.lastLoginSuccessIp;
    }

    public void setLastLoginSuccessIp(String lastLoginSuccessIp) {
        this.lastLoginSuccessIp = lastLoginSuccessIp;
    }

    public UserAccount lastLoginFailIp(String lastLoginFailIp) {
        this.lastLoginFailIp = lastLoginFailIp;
        return this;
    }

    @Schema(description="&#128679; Deprecated since v4.6.0  Last failed logon IP address")
    public String getLastLoginFailIp() {
        return this.lastLoginFailIp;
    }

    public void setLastLoginFailIp(String lastLoginFailIp) {
        this.lastLoginFailIp = lastLoginFailIp;
    }

    public UserAccount gender(String gender) {
        this.gender = gender;
        return this;
    }

    @Schema(description="&#128679; Deprecated since v4.12.0  Gender")
    public String getGender() {
        return this.gender;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    public UserAccount needsToChangeUserName(Boolean needsToChangeUserName) {
        this.needsToChangeUserName = needsToChangeUserName;
        return this;
    }

    @Schema(description="&#128679; Deprecated since v4.13.0  If `true`, the user must change the `userName` at the first login.")
    public Boolean isNeedsToChangeUserName() {
        return this.needsToChangeUserName;
    }

    public void setNeedsToChangeUserName(Boolean needsToChangeUserName) {
        this.needsToChangeUserName = needsToChangeUserName;
    }

    public UserAccount authMethods(List<UserAuthMethod> authMethods) {
        this.authMethods = authMethods;
        return this;
    }

    public UserAccount addAuthMethodsItem(UserAuthMethod authMethodsItem) {
        if (this.authMethods == null) {
            this.authMethods = new ArrayList<UserAuthMethod>();
        }
        this.authMethods.add(authMethodsItem);
        return this;
    }

    @Schema(description="&#128679; Deprecated since v4.13.0  Authentication methods:  * `sql`  * `active_directory`  * `radius`  * `openid`  use `authData` instead")
    public List<UserAuthMethod> getAuthMethods() {
        return this.authMethods;
    }

    public void setAuthMethods(List<UserAuthMethod> authMethods) {
        this.authMethods = authMethods;
    }

    public UserAccount login(String login) {
        this.login = login;
        return this;
    }

    @Schema(description="&#128679; Deprecated since v4.13.0  User login name")
    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public UserAccount lockStatus(Integer lockStatus) {
        this.lockStatus = lockStatus;
        return this;
    }

    @Schema(required=true, description="&#128679; Deprecated since v4.7.0  User lock status:  * `0` - locked  * `1` - Web access allowed  * `2` - Web and mobile access allowed    Please use `isLocked` instead.")
    public Integer getLockStatus() {
        return this.lockStatus;
    }

    public void setLockStatus(Integer lockStatus) {
        this.lockStatus = lockStatus;
    }

    public UserAccount customer(CustomerData customer) {
        this.customer = customer;
        return this;
    }

    @Schema(required=true, description="")
    public CustomerData getCustomer() {
        return this.customer;
    }

    public void setCustomer(CustomerData customer) {
        this.customer = customer;
    }

    public UserAccount needsToChangePassword(Boolean needsToChangePassword) {
        this.needsToChangePassword = needsToChangePassword;
        return this;
    }

    @Schema(required=true, description="&#128679; Deprecated since v4.13.0  Determines whether user has to change his / her password")
    public Boolean isNeedsToChangePassword() {
        return this.needsToChangePassword;
    }

    public void setNeedsToChangePassword(Boolean needsToChangePassword) {
        this.needsToChangePassword = needsToChangePassword;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserAccount userAccount = (UserAccount)o;
        return Objects.equals(this.id, userAccount.id) && Objects.equals(this.userName, userAccount.userName) && Objects.equals(this.firstName, userAccount.firstName) && Objects.equals(this.lastName, userAccount.lastName) && Objects.equals(this.isLocked, userAccount.isLocked) && Objects.equals(this.hasManageableRooms, userAccount.hasManageableRooms) && Objects.equals(this.userRoles, userAccount.userRoles) && Objects.equals(this.language, userAccount.language) && Objects.equals(this.authData, userAccount.authData) && Objects.equals(this.mustSetEmail, userAccount.mustSetEmail) && Objects.equals(this.needsToAcceptEULA, userAccount.needsToAcceptEULA) && Objects.equals(this.expireAt, userAccount.expireAt) && Objects.equals(this.isEncryptionEnabled, userAccount.isEncryptionEnabled) && Objects.equals(this.lastLoginSuccessAt, userAccount.lastLoginSuccessAt) && Objects.equals(this.lastLoginFailAt, userAccount.lastLoginFailAt) && Objects.equals(this.email, userAccount.email) && Objects.equals(this.phone, userAccount.phone) && Objects.equals(this.homeRoomId, userAccount.homeRoomId) && Objects.equals(this.userGroups, userAccount.userGroups) && Objects.equals(this.userAttributes, userAccount.userAttributes) && Objects.equals(this.title, userAccount.title) && Objects.equals(this.lastLoginSuccessIp, userAccount.lastLoginSuccessIp) && Objects.equals(this.lastLoginFailIp, userAccount.lastLoginFailIp) && Objects.equals(this.gender, userAccount.gender) && Objects.equals(this.needsToChangeUserName, userAccount.needsToChangeUserName) && Objects.equals(this.authMethods, userAccount.authMethods) && Objects.equals(this.login, userAccount.login) && Objects.equals(this.lockStatus, userAccount.lockStatus) && Objects.equals(this.customer, userAccount.customer) && Objects.equals(this.needsToChangePassword, userAccount.needsToChangePassword);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.userName, this.firstName, this.lastName, this.isLocked, this.hasManageableRooms, this.userRoles, this.language, this.authData, this.mustSetEmail, this.needsToAcceptEULA, this.expireAt, this.isEncryptionEnabled, this.lastLoginSuccessAt, this.lastLoginFailAt, this.email, this.phone, this.homeRoomId, this.userGroups, this.userAttributes, this.title, this.lastLoginSuccessIp, this.lastLoginFailIp, this.gender, this.needsToChangeUserName, this.authMethods, this.login, this.lockStatus, this.customer, this.needsToChangePassword);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserAccount {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    userName: ").append(this.toIndentedString(this.userName)).append("\n");
        sb.append("    firstName: ").append(this.toIndentedString(this.firstName)).append("\n");
        sb.append("    lastName: ").append(this.toIndentedString(this.lastName)).append("\n");
        sb.append("    isLocked: ").append(this.toIndentedString(this.isLocked)).append("\n");
        sb.append("    hasManageableRooms: ").append(this.toIndentedString(this.hasManageableRooms)).append("\n");
        sb.append("    userRoles: ").append(this.toIndentedString(this.userRoles)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    authData: ").append(this.toIndentedString(this.authData)).append("\n");
        sb.append("    mustSetEmail: ").append(this.toIndentedString(this.mustSetEmail)).append("\n");
        sb.append("    needsToAcceptEULA: ").append(this.toIndentedString(this.needsToAcceptEULA)).append("\n");
        sb.append("    expireAt: ").append(this.toIndentedString(this.expireAt)).append("\n");
        sb.append("    isEncryptionEnabled: ").append(this.toIndentedString(this.isEncryptionEnabled)).append("\n");
        sb.append("    lastLoginSuccessAt: ").append(this.toIndentedString(this.lastLoginSuccessAt)).append("\n");
        sb.append("    lastLoginFailAt: ").append(this.toIndentedString(this.lastLoginFailAt)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    phone: ").append(this.toIndentedString(this.phone)).append("\n");
        sb.append("    homeRoomId: ").append(this.toIndentedString(this.homeRoomId)).append("\n");
        sb.append("    userGroups: ").append(this.toIndentedString(this.userGroups)).append("\n");
        sb.append("    userAttributes: ").append(this.toIndentedString(this.userAttributes)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    lastLoginSuccessIp: ").append(this.toIndentedString(this.lastLoginSuccessIp)).append("\n");
        sb.append("    lastLoginFailIp: ").append(this.toIndentedString(this.lastLoginFailIp)).append("\n");
        sb.append("    gender: ").append(this.toIndentedString(this.gender)).append("\n");
        sb.append("    needsToChangeUserName: ").append(this.toIndentedString(this.needsToChangeUserName)).append("\n");
        sb.append("    authMethods: ").append(this.toIndentedString(this.authMethods)).append("\n");
        sb.append("    login: ").append(this.toIndentedString(this.login)).append("\n");
        sb.append("    lockStatus: ").append(this.toIndentedString(this.lockStatus)).append("\n");
        sb.append("    customer: ").append(this.toIndentedString(this.customer)).append("\n");
        sb.append("    needsToChangePassword: ").append(this.toIndentedString(this.needsToChangePassword)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

