/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.model;

import ch.cyberduck.core.sds.io.swagger.client.model.KeyValueEntry;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="Authentication method")
public class UserAuthMethod {
    @JsonProperty(value="authId")
    private String authId = null;
    @JsonProperty(value="isEnabled")
    private Boolean isEnabled = null;
    @JsonProperty(value="options")
    private List<KeyValueEntry> options = null;

    public UserAuthMethod authId(String authId) {
        this.authId = authId;
        return this;
    }

    @Schema(required=true, description="Authentication method    Authentication methods:  * `basic`  * `active_directory`  * `radius`  * `openid`")
    public String getAuthId() {
        return this.authId;
    }

    public void setAuthId(String authId) {
        this.authId = authId;
    }

    public UserAuthMethod isEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    @Schema(required=true, description="Is enabled")
    public Boolean isIsEnabled() {
        return this.isEnabled;
    }

    public void setIsEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public UserAuthMethod options(List<KeyValueEntry> options) {
        this.options = options;
        return this;
    }

    public UserAuthMethod addOptionsItem(KeyValueEntry optionsItem) {
        if (this.options == null) {
            this.options = new ArrayList<KeyValueEntry>();
        }
        this.options.add(optionsItem);
        return this;
    }

    @Schema(description="Authentication method options")
    public List<KeyValueEntry> getOptions() {
        return this.options;
    }

    public void setOptions(List<KeyValueEntry> options) {
        this.options = options;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserAuthMethod userAuthMethod = (UserAuthMethod)o;
        return Objects.equals(this.authId, userAuthMethod.authId) && Objects.equals(this.isEnabled, userAuthMethod.isEnabled) && Objects.equals(this.options, userAuthMethod.options);
    }

    public int hashCode() {
        return Objects.hash(this.authId, this.isEnabled, this.options);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserAuthMethod {\n");
        sb.append("    authId: ").append(this.toIndentedString(this.authId)).append("\n");
        sb.append("    isEnabled: ").append(this.toIndentedString(this.isEnabled)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

