/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.b2;

import ch.cyberduck.core.AbstractExceptionMappingService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ChecksumException;
import ch.cyberduck.core.exception.ExpiredTokenException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.exception.QuotaException;
import ch.cyberduck.core.exception.RetriableAccessDeniedException;
import ch.cyberduck.core.http.DefaultHttpResponseExceptionMappingService;
import java.time.Duration;
import org.apache.http.client.HttpResponseException;
import org.apache.log4j.Logger;
import synapticloop.b2.exception.B2ApiException;

public class B2ExceptionMappingService
extends AbstractExceptionMappingService<B2ApiException> {
    private static final Logger log = Logger.getLogger(B2ExceptionMappingService.class);

    public BackgroundException map(B2ApiException e) {
        StringBuilder buffer = new StringBuilder();
        this.append(buffer, e.getMessage());
        switch (e.getStatus()) {
            case 403: {
                if (!"cap_exceeded".equalsIgnoreCase(e.getCode()) && !"storage_cap_exceeded".equalsIgnoreCase(e.getCode()) && !"transaction_cap_exceeded".equalsIgnoreCase(e.getCode())) break;
                return new QuotaException(buffer.toString(), (Throwable)e);
            }
            case 400: {
                if ("file_not_present".equalsIgnoreCase(e.getCode())) {
                    return new NotfoundException(buffer.toString(), (Throwable)e);
                }
                if ("bad_bucket_id".equalsIgnoreCase(e.getCode())) {
                    return new NotfoundException(buffer.toString(), (Throwable)e);
                }
                if ("cap_exceeded".equalsIgnoreCase(e.getCode())) {
                    return new QuotaException(buffer.toString(), (Throwable)e);
                }
                if ("too_many_buckets".equalsIgnoreCase(e.getCode())) {
                    return new QuotaException(buffer.toString(), (Throwable)e);
                }
                if (!"bad_request".equalsIgnoreCase(e.getCode()) || !"sha1 did not match data received".equalsIgnoreCase(e.getMessage())) break;
                return new ChecksumException(buffer.toString(), (Throwable)e);
            }
            case 401: {
                if (!"expired_auth_token".equalsIgnoreCase(e.getCode())) break;
                return new ExpiredTokenException(buffer.toString(), (Throwable)e);
            }
            default: {
                if (e.getRetry() == null) break;
                return new RetriableAccessDeniedException(buffer.toString(), Duration.ofSeconds(e.getRetry().intValue()), (Throwable)e);
            }
        }
        return new DefaultHttpResponseExceptionMappingService().map(new HttpResponseException(e.getStatus(), buffer.toString()));
    }
}

