/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.http.signature.apache.httpclient;

import com.joyent.http.signature.HttpSignatureException;
import com.joyent.http.signature.Signer;
import java.security.KeyPair;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;

class HttpSignatureCache {
    private final Credentials credentials;
    private String lastDate = "";
    private String lastSignature = "";

    HttpSignatureCache(Credentials credentials) {
        if (credentials == null) {
            throw new IllegalArgumentException("Credentials must be present");
        }
        if (credentials.getUserPrincipal() == null) {
            throw new IllegalArgumentException("User principal must be present");
        }
        if (credentials.getUserPrincipal().getName() == null) {
            throw new IllegalArgumentException("User principal name must be present");
        }
        this.credentials = credentials;
    }

    synchronized String updateAndGetSignature(String stringDate, Signer signer, KeyPair keyPair) throws AuthenticationException {
        if (this.lastDate.equals(stringDate)) {
            return this.lastSignature;
        }
        this.lastDate = stringDate;
        String login = this.credentials.getUserPrincipal().getName();
        try {
            String authz;
            this.lastSignature = authz = signer.createAuthorizationHeader(login, keyPair, stringDate);
            return authz;
        }
        catch (HttpSignatureException e) {
            String details = String.format("Unable to authenticate [%s] using keypair [%s]", login, keyPair);
            throw new AuthenticationException(details, (Throwable)e);
        }
    }
}

