/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.cli;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.filter.DownloadDuplicateFilter;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class DownloadGlobFilter
extends DownloadDuplicateFilter {
    private static final Logger log = Logger.getLogger(DownloadGlobFilter.class);
    private final Pattern pattern;

    public DownloadGlobFilter(String glob) {
        this.pattern = this.compile(glob);
    }

    protected Pattern compile(String glob) {
        StringBuilder pattern = new StringBuilder();
        pattern.append("\\A");
        for (int i = 0; i < glob.length(); ++i) {
            char ch = glob.charAt(i);
            if (ch == '?') {
                pattern.append('.');
                continue;
            }
            if (ch == '*') {
                pattern.append(".*");
                continue;
            }
            if ("\\[]^.-$+(){}|".indexOf(ch) != -1) {
                pattern.append('\\');
                pattern.append(ch);
                continue;
            }
            pattern.append(ch);
        }
        pattern.append("\\z");
        return Pattern.compile(pattern.toString());
    }

    @Override
    public boolean accept(Path file) {
        if (!super.accept(file)) {
            return false;
        }
        if (this.pattern.matcher(file.getName()).matches()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Skip %s excluded with regex", file.getAbsolute()));
        }
        return false;
    }

    @Override
    public Pattern toPattern() {
        return this.pattern;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DownloadGlobFilter{");
        sb.append("pattern=").append(this.pattern);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DownloadGlobFilter)) {
            return false;
        }
        DownloadGlobFilter that = (DownloadGlobFilter)o;
        return Objects.equals(this.pattern, that.pattern);
    }

    public int hashCode() {
        return Objects.hash(this.pattern);
    }
}

