/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.preferences;

import ch.cyberduck.binding.foundation.NSFileManager;
import ch.cyberduck.binding.foundation.NSURL;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.LocalAccessDeniedException;
import ch.cyberduck.core.local.FinderLocal;
import ch.cyberduck.core.local.LocalSymlinkFactory;
import ch.cyberduck.core.local.LocalTrashFactory;
import ch.cyberduck.core.local.features.Symlink;
import ch.cyberduck.core.local.features.Trash;
import ch.cyberduck.core.preferences.ApplicationSupportDirectoryFinder;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.preferences.SupportDirectoryFinder;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.rococoa.Foundation;

public class SecurityApplicationGroupSupportDirectoryFinder
implements SupportDirectoryFinder {
    private static final Logger log = Logger.getLogger(SecurityApplicationGroupSupportDirectoryFinder.class);
    private final String identifier;

    public SecurityApplicationGroupSupportDirectoryFinder() {
        this(String.format("%s.%s", PreferencesFactory.get().getProperty("application.container.teamidentifier"), PreferencesFactory.get().getProperty("application.container.name")));
    }

    public SecurityApplicationGroupSupportDirectoryFinder(String identifier) {
        this.identifier = identifier;
    }

    public Local find() {
        NSFileManager manager = NSFileManager.defaultManager();
        if (manager.respondsToSelector(Foundation.selector((String)"containerURLForSecurityApplicationGroupIdentifier:"))) {
            NSURL group = manager.containerURLForSecurityApplicationGroupIdentifier(this.identifier);
            if (null == group) {
                log.warn((Object)"Missing com.apple.security.application-groups in sandbox entitlements");
            } else {
                String application = PreferencesFactory.get().getProperty("application.datafolder.name");
                FinderLocal folder = new FinderLocal(String.format("%s/Library/Application Support", group.path()), application);
                try {
                    Local previous = new ApplicationSupportDirectoryFinder().find();
                    if (previous.exists()) {
                        log.warn((Object)String.format("Migrate application support folder from %s to %s", new Object[]{previous, folder}));
                        try {
                            FileUtils.copyDirectory((File)new File(previous.getAbsolute()), (File)new File(folder.getAbsolute()));
                            log.warn((Object)String.format("Move application support folder %s to Trash", previous));
                            try {
                                Trash trash = LocalTrashFactory.get();
                                trash.trash(previous);
                                Symlink symlink = LocalSymlinkFactory.get();
                                symlink.symlink(previous, folder.getAbsolute());
                            }
                            catch (LocalAccessDeniedException e) {
                                log.warn((Object)String.format("Failure cleaning up previous application support directory. %s", e.getMessage()));
                            }
                        }
                        catch (IOException e) {
                            log.warn((Object)String.format("Failure migrating %s to security application group directory %s. %s", new Object[]{previous, folder, e.getMessage()}));
                        }
                    } else {
                        log.debug((Object)String.format("No previous application support folder found in %s", previous));
                    }
                    return folder;
                }
                catch (AccessDeniedException e) {
                    log.warn((Object)String.format("Failure creating security application group directory. %s", e.getMessage()));
                }
            }
        }
        log.warn((Object)"Missing support for security application groups. Default to application support directory");
        return new ApplicationSupportDirectoryFinder().find();
    }
}

