/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.resources;

import ch.cyberduck.binding.application.NSImage;
import ch.cyberduck.binding.application.NSWorkspace;
import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.local.Application;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.resources.IconCache;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.rococoa.cocoa.foundation.NSPoint;
import org.rococoa.cocoa.foundation.NSRect;
import org.rococoa.cocoa.foundation.NSSize;

public class NSImageIconCache
implements IconCache<NSImage> {
    private static final Logger log = Logger.getLogger(NSImageIconCache.class);
    private static final NSRect NSZeroRect = new NSRect(0.0, 0.0);
    private final NSWorkspace workspace = NSWorkspace.sharedWorkspace();

    private NSImage cache(String name, NSImage image, Integer size) {
        if (null == image) {
            log.warn((Object)String.format("No icon named %s", name));
            return image;
        }
        if (null == name) {
            return image;
        }
        image.setName(null == size ? name : NSImageIconCache.toName(name, size));
        return image;
    }

    private static String toName(String name, Integer size) {
        return String.format("%s (%dpx)", name, size);
    }

    private NSImage load(String name, Integer size) {
        NSImage cached = NSImage.imageNamed((String)NSImageIconCache.toName(name, size));
        if (null == cached && log.isDebugEnabled()) {
            log.debug((Object)String.format("No cached image for %s", name));
        }
        return cached;
    }

    public NSImage documentIcon(String extension, Integer size) {
        NSImage image = this.load(extension, size);
        if (null == image) {
            return this.cache(extension, this.convert(extension, this.workspace.iconForFileType(extension), size), size);
        }
        return image;
    }

    public NSImage documentIcon(String extension, Integer size, NSImage badge) {
        String name = String.format("NSDocument-%s%s", extension, badge.name());
        NSImage icon = (NSImage)this.iconNamed(name, size);
        if (null == icon) {
            icon = this.badge(badge, this.documentIcon(extension, size));
            this.cache(name, icon, size);
        }
        return icon;
    }

    public NSImage folderIcon(Integer size) {
        NSImage folder = (NSImage)this.iconNamed("NSFolder", size);
        if (null == folder) {
            return (NSImage)this.iconNamed("NSFolder", size);
        }
        return folder;
    }

    public NSImage folderIcon(Integer size, NSImage badge) {
        String name = String.format("NSFolder-%s", badge.name());
        NSImage folder = this.load(name, size);
        if (null == folder) {
            folder = this.convert(name, (NSImage)this.iconNamed("NSFolder", size), size);
            folder = this.badge(badge, folder);
            this.cache(name, folder, size);
        }
        return folder;
    }

    private NSImage badge(NSImage badge, NSImage icon) {
        NSImage f = NSImage.imageWithSize((NSSize)icon.size());
        f.lockFocus();
        icon.drawInRect(new NSRect(new NSPoint(0.0, 0.0), icon.size()), NSZeroRect, 2, 1.0);
        badge.drawInRect(new NSRect(new NSPoint(0.0, 0.0), badge.size()), NSZeroRect, 2, 1.0);
        f.unlockFocus();
        return f;
    }

    public NSImage iconNamed(String name, Integer width, Integer height) {
        NSImage image = this.load(name, width);
        if (null == image) {
            if (null == name) {
                return this.iconNamed("notfound.tiff", width, height);
            }
            if (name.contains(PreferencesFactory.get().getProperty("local.delimiter"))) {
                return this.cache(FilenameUtils.getName((String)name), this.convert(FilenameUtils.getName((String)name), NSImage.imageWithContentsOfFile((String)name), width, height), width);
            }
            return this.cache(name, this.convert(name, NSImage.imageNamed((String)name), width, height), width);
        }
        return image;
    }

    public NSImage fileIcon(Local file, Integer size) {
        NSImage icon = null;
        if (file.exists() && null == (icon = this.load(file.getAbsolute(), size))) {
            return this.cache(file.getName(), this.convert(file.getName(), this.workspace.iconForFile(file.getAbsolute()), size), size);
        }
        if (null == icon) {
            return (NSImage)this.iconNamed("notfound.tiff", size);
        }
        return icon;
    }

    public NSImage applicationIcon(Application app, Integer size) {
        String path;
        NSImage icon = this.load(app.getIdentifier(), size);
        if (null == icon && StringUtils.isNotBlank((CharSequence)(path = this.workspace.absolutePathForAppBundleWithIdentifier(app.getIdentifier())))) {
            return this.cache(app.getIdentifier(), this.convert(app.getIdentifier(), this.workspace.iconForFile(path), size), size);
        }
        if (null == icon) {
            return (NSImage)this.iconNamed("notfound.tiff", size);
        }
        return icon;
    }

    public NSImage fileIcon(Path file, Integer size) {
        if (file.getType().contains(AbstractPath.Type.decrypted)) {
            NSImage badge = (NSImage)this.iconNamed("unlockedbadge.tiff", size);
            badge.setName("unlockedbadge");
            if (file.isDirectory()) {
                return this.folderIcon(size, badge);
            }
            return this.documentIcon(StringUtils.lowerCase((String)file.getExtension()), size, badge);
        }
        if (file.isSymbolicLink()) {
            NSImage badge = (NSImage)this.iconNamed("aliasbadge.tiff", size);
            badge.setName("aliasbadge");
            if (file.isDirectory()) {
                return this.folderIcon(size, badge);
            }
            return this.documentIcon(StringUtils.lowerCase((String)file.getExtension()), size, badge);
        }
        if (file.isFile()) {
            if (StringUtils.isEmpty((CharSequence)file.getExtension()) && file.attributes().getPermission().isExecutable()) {
                return (NSImage)this.iconNamed("executable.tiff", size);
            }
            return this.documentIcon(StringUtils.lowerCase((String)file.getExtension()), size);
        }
        if (file.isDirectory()) {
            if (Permission.EMPTY != file.attributes().getPermission()) {
                if (!file.attributes().getPermission().isExecutable()) {
                    NSImage badge = (NSImage)this.iconNamed("privatefolderbadge.tiff", size);
                    badge.setName("privatefolderbadge");
                    return this.folderIcon(size, badge);
                }
                if (!file.attributes().getPermission().isReadable() && file.attributes().getPermission().isWritable()) {
                    NSImage badge = (NSImage)this.iconNamed("dropfolderbadge.tiff", size);
                    badge.setName("dropfolderbadge");
                    return this.folderIcon(size, badge);
                }
                if (!file.attributes().getPermission().isWritable()) {
                    NSImage badge = (NSImage)this.iconNamed("readonlyfolderbadge.tiff", size);
                    badge.setName("readonlyfolderbadge");
                    return this.folderIcon(size, badge);
                }
            }
            return this.folderIcon(size);
        }
        return (NSImage)this.iconNamed("notfound.tiff", size);
    }

    public NSImage aliasIcon(String extension, Integer size) {
        return this.badge((NSImage)this.iconNamed("aliasbadge.tiff", size), this.documentIcon(extension, size));
    }

    private NSImage convert(String name, NSImage icon, Integer size) {
        return this.convert(name, icon, size, size);
    }

    private NSImage convert(String name, NSImage image, Integer width, Integer height) {
        if (null == image) {
            return null;
        }
        if (StringUtils.equals((CharSequence)Path.getExtension((String)name), (CharSequence)"pdf")) {
            image.setTemplate(true);
        }
        if (null == width || null == height) {
            log.debug((Object)String.format("Return default size for %s", image.name()));
            return image;
        }
        NSImage copy = image.copy();
        copy.setSize(new NSSize((double)width.intValue(), (double)height.intValue()));
        return copy;
    }
}

