/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.spectra;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.PathNormalizer;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.s3.S3AbstractListService;
import ch.cyberduck.core.s3.S3PathContainerService;
import ch.cyberduck.core.spectra.SpectraClientBuilder;
import ch.cyberduck.core.spectra.SpectraExceptionMappingService;
import ch.cyberduck.core.spectra.SpectraSession;
import com.spectralogic.ds3client.Ds3Client;
import com.spectralogic.ds3client.commands.GetBucketRequest;
import com.spectralogic.ds3client.commands.GetBucketResponse;
import com.spectralogic.ds3client.models.Contents;
import com.spectralogic.ds3client.models.common.CommonPrefixes;
import com.spectralogic.ds3client.networking.FailedRequestException;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jets3t.service.impl.rest.httpclient.RestStorageService;

public class SpectraObjectListService
extends S3AbstractListService {
    private static final Logger log = Logger.getLogger(SpectraObjectListService.class);
    private final Preferences preferences = PreferencesFactory.get();
    private final PathContainerService containerService = new S3PathContainerService();
    private final SpectraSession session;

    public SpectraObjectListService(SpectraSession session) {
        this.session = session;
    }

    public AttributedList<Path> list(Path directory, ListProgressListener listener) throws BackgroundException {
        return this.list(directory, listener, this.preferences.getInteger("s3.listing.chunksize"));
    }

    @NotNull
    protected AttributedList<Path> list(Path directory, ListProgressListener listener, int chunksize) throws BackgroundException {
        try {
            GetBucketResponse response;
            boolean truncated;
            String prefix = this.createPrefix(directory);
            AttributedList objects = new AttributedList();
            Ds3Client client = new SpectraClientBuilder().wrap((RestStorageService)this.session.getClient(), this.session.getHost());
            Path bucket = this.containerService.getContainer(directory);
            long revision = 0L;
            String marker = null;
            String lastKey = null;
            boolean hasDirectoryPlaceholder = this.containerService.isContainer(directory);
            do {
                String key;
                response = client.getBucket(new GetBucketRequest(bucket.getName()).withVersions(true).withDelimiter(String.valueOf('/')).withMarker(marker).withPrefix(StringUtils.isBlank((CharSequence)prefix) ? "" : prefix).withMaxKeys(chunksize));
                for (Contents object : response.getListBucketResult().getObjects()) {
                    key = PathNormalizer.normalize((String)object.getKey());
                    if (String.valueOf('/').equals(key)) {
                        log.warn((Object)String.format("Skipping prefix %s", key));
                        continue;
                    }
                    if (new Path(bucket, key, EnumSet.of(AbstractPath.Type.directory)).equals((Object)directory)) {
                        hasDirectoryPlaceholder = true;
                        continue;
                    }
                    objects.add((Referenceable)new Path(directory, PathNormalizer.name((String)key), object.getKey().endsWith(String.valueOf('/')) ? EnumSet.of(AbstractPath.Type.directory) : EnumSet.of(AbstractPath.Type.file), this.toAttributes(object)));
                }
                for (Contents object : response.getListBucketResult().getVersionedObjects()) {
                    key = PathNormalizer.normalize((String)object.getKey());
                    if (String.valueOf('/').equals(key)) {
                        log.warn((Object)String.format("Skipping prefix %s", key));
                        continue;
                    }
                    if (new Path(bucket, key, EnumSet.of(AbstractPath.Type.directory)).equals((Object)directory)) {
                        hasDirectoryPlaceholder = true;
                        continue;
                    }
                    if (!StringUtils.equals(lastKey, (CharSequence)key)) {
                        revision = 0L;
                    }
                    PathAttributes attributes = this.toAttributes(object);
                    attributes.setRevision(Long.valueOf(++revision));
                    if (attributes.isDuplicate() && attributes.getRevision() == 1L) {
                        HashMap<String, String> custom = new HashMap<String, String>(attributes.getCustom());
                        custom.put("revertable", Boolean.TRUE.toString());
                        attributes.setCustom(custom);
                    }
                    objects.add((Referenceable)new Path(directory, PathNormalizer.name((String)key), object.getKey().endsWith(String.valueOf('/')) ? EnumSet.of(AbstractPath.Type.directory) : EnumSet.of(AbstractPath.Type.file), attributes));
                    lastKey = key;
                }
                for (CommonPrefixes common : response.getListBucketResult().getCommonPrefixes()) {
                    if (String.valueOf('/').equals(common.getPrefix())) {
                        log.warn((Object)String.format("Skipping prefix %s", common.getPrefix()));
                        continue;
                    }
                    key = PathNormalizer.normalize((String)common.getPrefix());
                    if (new Path(bucket, key, EnumSet.of(AbstractPath.Type.directory)).equals((Object)directory)) continue;
                    objects.add((Referenceable)new Path(directory, PathNormalizer.name((String)key), EnumSet.of(AbstractPath.Type.directory, AbstractPath.Type.placeholder), new PathAttributes()));
                }
                marker = response.getListBucketResult().getNextMarker();
                listener.chunk(directory, objects);
            } while (truncated = response.getListBucketResult().getTruncated());
            if (!hasDirectoryPlaceholder && objects.isEmpty()) {
                throw new NotfoundException(directory.getAbsolute());
            }
            return objects;
        }
        catch (FailedRequestException e) {
            throw new SpectraExceptionMappingService().map("Listing directory {0} failed", e, directory);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Listing directory {0} failed", (Throwable)e, directory);
        }
    }

    @NotNull
    private PathAttributes toAttributes(Contents object) {
        PathAttributes attr = new PathAttributes();
        attr.setETag(object.getETag());
        attr.setModificationDate(object.getLastModified().getTime());
        attr.setOwner(object.getOwner().getDisplayName());
        attr.setSize(object.getSize());
        attr.setStorageClass(object.getStorageClass());
        attr.setVersionId(object.getVersionId().toString());
        Boolean latest = object.getIsLatest();
        attr.setDuplicate(object.getSize() == 0L || latest == false);
        return attr;
    }
}

