/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import java.util.EnumSet;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractPath {
    public static final String HOME = "~";

    public abstract EnumSet<Type> getType();

    public abstract char getDelimiter();

    public boolean isRoot() {
        return this.getAbsolute().equals(String.valueOf(this.getDelimiter()));
    }

    public abstract String getAbsolute();

    public abstract String getName();

    public String getExtension() {
        return AbstractPath.getExtension(this.getName());
    }

    public static String getExtension(String filename) {
        int extensionPos = AbstractPath.indexOfExtension(filename);
        if (-1 == extensionPos) {
            return "";
        }
        return filename.substring(extensionPos + 1);
    }

    public static int indexOfExtension(String filename) {
        if (StringUtils.isBlank((CharSequence)filename)) {
            return -1;
        }
        int extensionPos = filename.lastIndexOf(46);
        if (-1 == extensionPos) {
            return -1;
        }
        int lastSeparator = FilenameUtils.indexOfLastSeparator((String)filename);
        if (lastSeparator > extensionPos) {
            return -1;
        }
        return extensionPos;
    }

    public static enum Type {
        file{

            @Override
            public int legacy() {
                return 1;
            }
        }
        ,
        directory{

            @Override
            public int legacy() {
                return 2;
            }
        }
        ,
        symboliclink{

            @Override
            public int legacy() {
                return 4;
            }
        }
        ,
        shared{

            @Override
            public int legacy() {
                return 0;
            }
        }
        ,
        volume{

            @Override
            public int legacy() {
                return 8;
            }
        }
        ,
        placeholder{

            @Override
            public int legacy() {
                return 0;
            }
        }
        ,
        upload{

            @Override
            public int legacy() {
                return 0;
            }
        }
        ,
        triplecrypt{

            @Override
            public int legacy() {
                return 0;
            }
        }
        ,
        encrypted{

            @Override
            public int legacy() {
                return 0;
            }
        }
        ,
        decrypted{

            @Override
            public int legacy() {
                return 0;
            }
        }
        ,
        vault{

            @Override
            public int legacy() {
                return 0;
            }
        };


        public abstract int legacy();
    }
}

