/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.AbstractExceptionMappingService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.ssl.SSLExceptionMappingService;
import java.io.IOException;
import javax.net.ssl.SSLException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class DefaultIOExceptionMappingService
extends AbstractExceptionMappingService<IOException> {
    public BackgroundException map(IOException failure, Path directory) {
        return super.map("Connection failed", failure, directory);
    }

    @Override
    public BackgroundException map(IOException failure) {
        Throwable[] stack;
        for (Throwable t : stack = ExceptionUtils.getThrowables((Throwable)failure)) {
            if (!(t instanceof BackgroundException)) continue;
            return (BackgroundException)t;
        }
        if (failure instanceof SSLException) {
            return new SSLExceptionMappingService().map((SSLException)failure);
        }
        StringBuilder buffer = new StringBuilder();
        this.append(buffer, failure.getMessage());
        for (Throwable cause : ExceptionUtils.getThrowableList((Throwable)failure)) {
            if (StringUtils.contains((CharSequence)failure.getMessage(), (CharSequence)cause.getMessage())) continue;
            this.append(buffer, cause.getMessage());
        }
        return this.wrap(failure, buffer);
    }
}

