/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.diagnostics;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.diagnostics.Reachability;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import java.io.IOException;
import java.net.InetAddress;

public class DefaultInetAddressReachability
implements Reachability {
    private final Preferences preferences = PreferencesFactory.get();

    @Override
    public boolean isReachable(Host host) {
        try {
            return InetAddress.getByName(host.getHostname()).isReachable(this.preferences.getInteger("connection.timeout.seconds") * 1000);
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public void diagnose(Host host) {
    }

    @Override
    public Reachability.Monitor monitor(Host host, Reachability.Callback callback) {
        return new DisabledMonitor();
    }

    private static class DisabledMonitor
    implements Reachability.Monitor {
        private DisabledMonitor() {
        }

        @Override
        public Reachability.Monitor start() {
            return this;
        }

        @Override
        public Reachability.Monitor stop() {
            return this;
        }
    }
}

