/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.http;

import ch.cyberduck.core.transfer.TransferStatus;
import java.util.Objects;

public class HttpRange {
    private final Long start;
    private final Long end;
    private final Long length;

    public static HttpRange withStatus(TransferStatus status) {
        return HttpRange.byLength(status.getOffset(), status.getLength());
    }

    public static HttpRange byPosition(long start, long end) {
        return new HttpRange(start, end);
    }

    public static HttpRange byLength(long offset, long length) {
        return new HttpRange(offset, -1L == length ? -1L : offset + length - 1L);
    }

    public HttpRange(long start, long end) {
        this(start, end, -1L == end ? -1L : end - start + 1L);
    }

    public HttpRange(Long start, Long end, Long length) {
        this.start = start;
        this.end = end;
        this.length = length;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public long getLength() {
        return this.length;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HttpRange)) {
            return false;
        }
        HttpRange httpRange = (HttpRange)o;
        return Objects.equals(this.start, httpRange.start) && Objects.equals(this.end, httpRange.end) && Objects.equals(this.length, httpRange.length);
    }

    public int hashCode() {
        return Objects.hash(this.start, this.end, this.length);
    }
}

