/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.http;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ChecksumException;
import ch.cyberduck.core.features.Upload;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.DefaultHttpResponseExceptionMappingService;
import ch.cyberduck.core.http.HttpExceptionMappingService;
import ch.cyberduck.core.io.BandwidthThrottle;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.io.StatusOutputStream;
import ch.cyberduck.core.io.StreamCancelation;
import ch.cyberduck.core.io.StreamCopier;
import ch.cyberduck.core.io.StreamListener;
import ch.cyberduck.core.io.StreamProgress;
import ch.cyberduck.core.io.ThrottledOutputStream;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.text.MessageFormat;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.http.client.HttpResponseException;
import org.apache.log4j.Logger;

public class HttpUploadFeature<Reply, Digest>
implements Upload<Reply> {
    private static final Logger log = Logger.getLogger(HttpUploadFeature.class);
    private Write<Reply> writer;

    public HttpUploadFeature(Write<Reply> writer) {
        this.writer = writer;
    }

    @Override
    public Write.Append append(Path file, Long length, Cache<Path> cache) throws BackgroundException {
        return this.writer.append(file, length, cache);
    }

    @Override
    public Reply upload(Path file, Local local, BandwidthThrottle throttle, StreamListener listener, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        return this.upload(file, local, throttle, listener, status, status, status, callback);
    }

    public Reply upload(Path file, Local local, BandwidthThrottle throttle, StreamListener listener, TransferStatus status, StreamCancelation cancel, StreamProgress progress, ConnectionCallback callback) throws BackgroundException {
        try {
            Digest digest = this.digest();
            InputStream in = this.decorate(local.getInputStream(), digest);
            StatusOutputStream<Reply> out = this.writer.write(file, status, callback);
            new StreamCopier(cancel, progress).withOffset(status.getOffset()).withLimit(status.getLength()).withListener(listener).transfer(in, (OutputStream)((Object)new ThrottledOutputStream((OutputStream)((Object)out), throttle)));
            Reply response = out.getStatus();
            this.post(file, digest, response);
            return response;
        }
        catch (HttpResponseException e) {
            throw new DefaultHttpResponseExceptionMappingService().map("Upload {0} failed", e, file);
        }
        catch (IOException e) {
            throw new HttpExceptionMappingService().map("Upload {0} failed", e, file);
        }
    }

    protected InputStream decorate(InputStream in, Digest digest) throws IOException {
        return in;
    }

    protected Digest digest() throws IOException {
        return null;
    }

    protected void post(Path file, Digest digest, Reply response) throws BackgroundException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Received response %s", response));
        }
    }

    protected void verify(Path file, MessageDigest digest, Checksum checksum) throws ChecksumException {
        if (file.getType().contains((Object)AbstractPath.Type.encrypted)) {
            log.warn((Object)String.format("Skip checksum verification for %s with client side encryption enabled", file));
            return;
        }
        if (null == digest) {
            log.debug((Object)String.format("Digest disabled for file %s", file));
            return;
        }
        Checksum expected = Checksum.parse(Hex.encodeHexString((byte[])digest.digest()));
        if (ObjectUtils.notEqual((Object)((Object)expected.algorithm), (Object)((Object)checksum.algorithm))) {
            log.warn((Object)String.format("ETag %s returned by server is %s but expected %s", new Object[]{checksum.hash, checksum.algorithm, expected.algorithm}));
        } else if (!checksum.equals(expected)) {
            throw new ChecksumException(MessageFormat.format(LocaleFactory.localizedString("Upload {0} failed", "Error"), file.getName()), MessageFormat.format("Mismatch between MD5 hash {0} of uploaded data and ETag {1} returned by the server", expected, checksum.hash));
        }
    }

    @Override
    public Upload<Reply> withWriter(Write<Reply> writer) {
        this.writer = writer;
        return this;
    }
}

